/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class AudioBlock
extends AbstractBlock {
    @JsonProperty(value="url")
    private final UrlConfig url;
    @JsonProperty(value="options")
    private final OptionsConfig options;
    @JsonProperty(value="title")
    private final TitleConfig title;

    private AudioBlock(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.options = builder.options;
        this.title = builder.title;
    }

    @Override
    public BlockType getType() {
        return BlockType.AUDIO;
    }

    public UrlConfig getUrl() {
        return this.url;
    }

    public OptionsConfig getOptions() {
        return this.options;
    }

    public TitleConfig getTitle() {
        return this.title;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioBlock)) {
            return false;
        }
        AudioBlock that = (AudioBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.url, that.url) && Objects.equals(this.options, that.options) && Objects.equals(this.title, that.title);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url, this.options, this.title);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private UrlConfig url;
        private OptionsConfig options;
        private TitleConfig title;

        public Builder url(UrlConfig url) {
            this.url = url;
            return this;
        }

        public Builder options(OptionsConfig options) {
            this.options = options;
            return this;
        }

        public Builder title(TitleConfig title) {
            this.title = title;
            return this;
        }

        @Override
        public AudioBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new AudioBlock(this);
        }
    }

    @JsonDeserialize(builder=UrlConfigBuilder.class)
    public static class UrlConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="severity")
        private final Severity severity;

        private UrlConfig(UrlConfigBuilder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static UrlConfigBuilder builder() {
            return new UrlConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrlConfig)) {
                return false;
            }
            UrlConfig that = (UrlConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && Objects.equals((Object)this.severity, (Object)that.severity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class UrlConfigBuilder {
            private boolean required;
            private Pattern pattern;
            private Severity severity;

            public UrlConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public UrlConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public UrlConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public UrlConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public UrlConfig build() {
                return new UrlConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=OptionsConfigBuilder.class)
    public static class OptionsConfig {
        @JsonProperty(value="autoplay")
        private final AutoplayConfig autoplay;
        @JsonProperty(value="controls")
        private final ControlsConfig controls;
        @JsonProperty(value="loop")
        private final LoopConfig loop;

        private OptionsConfig(OptionsConfigBuilder builder) {
            this.autoplay = builder.autoplay;
            this.controls = builder.controls;
            this.loop = builder.loop;
        }

        public AutoplayConfig getAutoplay() {
            return this.autoplay;
        }

        public ControlsConfig getControls() {
            return this.controls;
        }

        public LoopConfig getLoop() {
            return this.loop;
        }

        public static OptionsConfigBuilder builder() {
            return new OptionsConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OptionsConfig)) {
                return false;
            }
            OptionsConfig that = (OptionsConfig)o;
            return Objects.equals(this.autoplay, that.autoplay) && Objects.equals(this.controls, that.controls) && Objects.equals(this.loop, that.loop);
        }

        public int hashCode() {
            return Objects.hash(this.autoplay, this.controls, this.loop);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class OptionsConfigBuilder {
            private AutoplayConfig autoplay;
            private ControlsConfig controls;
            private LoopConfig loop;

            public OptionsConfigBuilder autoplay(AutoplayConfig autoplay) {
                this.autoplay = autoplay;
                return this;
            }

            public OptionsConfigBuilder controls(ControlsConfig controls) {
                this.controls = controls;
                return this;
            }

            public OptionsConfigBuilder loop(LoopConfig loop) {
                this.loop = loop;
                return this;
            }

            public OptionsConfig build() {
                return new OptionsConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=TitleConfigBuilder.class)
    public static class TitleConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TitleConfig(TitleConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TitleConfigBuilder builder() {
            return new TitleConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TitleConfig)) {
                return false;
            }
            TitleConfig that = (TitleConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals((Object)this.severity, (Object)that.severity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TitleConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;
            private Severity severity;

            public TitleConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TitleConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public TitleConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public TitleConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TitleConfig build() {
                return new TitleConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=LoopConfigBuilder.class)
    public static class LoopConfig {
        @JsonProperty(value="allowed")
        private final boolean allowed;
        @JsonProperty(value="severity")
        private final Severity severity;

        private LoopConfig(LoopConfigBuilder builder) {
            this.allowed = builder.allowed;
            this.severity = builder.severity;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static LoopConfigBuilder builder() {
            return new LoopConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoopConfig)) {
                return false;
            }
            LoopConfig that = (LoopConfig)o;
            return this.allowed == that.allowed && Objects.equals((Object)this.severity, (Object)that.severity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.allowed, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class LoopConfigBuilder {
            private boolean allowed;
            private Severity severity;

            public LoopConfigBuilder allowed(boolean allowed) {
                this.allowed = allowed;
                return this;
            }

            public LoopConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public LoopConfig build() {
                return new LoopConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=ControlsConfigBuilder.class)
    public static class ControlsConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="severity")
        private final Severity severity;

        private ControlsConfig(ControlsConfigBuilder builder) {
            this.required = builder.required;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static ControlsConfigBuilder builder() {
            return new ControlsConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ControlsConfig)) {
                return false;
            }
            ControlsConfig that = (ControlsConfig)o;
            return this.required == that.required && Objects.equals((Object)this.severity, (Object)that.severity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ControlsConfigBuilder {
            private boolean required;
            private Severity severity;

            public ControlsConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public ControlsConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public ControlsConfig build() {
                return new ControlsConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=AutoplayConfigBuilder.class)
    public static class AutoplayConfig {
        @JsonProperty(value="allowed")
        private final boolean allowed;
        @JsonProperty(value="severity")
        private final Severity severity;

        private AutoplayConfig(AutoplayConfigBuilder builder) {
            this.allowed = builder.allowed;
            this.severity = builder.severity;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static AutoplayConfigBuilder builder() {
            return new AutoplayConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AutoplayConfig)) {
                return false;
            }
            AutoplayConfig that = (AutoplayConfig)o;
            return this.allowed == that.allowed && Objects.equals((Object)this.severity, (Object)that.severity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.allowed, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class AutoplayConfigBuilder {
            private boolean allowed;
            private Severity severity;

            public AutoplayConfigBuilder allowed(boolean allowed) {
                this.allowed = allowed;
                return this;
            }

            public AutoplayConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public AutoplayConfig build() {
                return new AutoplayConfig(this);
            }
        }
    }
}

