/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public class ExampleBlock
extends AbstractBlock {
    private final CaptionConfig caption;
    private final CollapsibleConfig collapsible;

    private ExampleBlock(Builder builder) {
        super(builder);
        this.caption = builder.caption;
        this.collapsible = builder.collapsible;
    }

    @Override
    public BlockType getType() {
        return BlockType.EXAMPLE;
    }

    public CaptionConfig getCaption() {
        return this.caption;
    }

    public CollapsibleConfig getCollapsible() {
        return this.collapsible;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExampleBlock that = (ExampleBlock)o;
        return Objects.equals(this.caption, that.caption) && Objects.equals(this.collapsible, that.collapsible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.caption, this.collapsible);
    }

    public String toString() {
        return "ExampleBlock{name='" + this.getName() + "', severity=" + String.valueOf((Object)this.getSeverity()) + ", occurrence=" + String.valueOf(this.getOccurrence()) + ", caption=" + String.valueOf(this.caption) + ", collapsible=" + String.valueOf(this.collapsible) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private CaptionConfig caption;
        private CollapsibleConfig collapsible;

        @JsonProperty(value="caption")
        public Builder caption(CaptionConfig caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="collapsible")
        public Builder collapsible(CollapsibleConfig collapsible) {
            this.collapsible = collapsible;
            return this;
        }

        @Override
        public ExampleBlock build() {
            return new ExampleBlock(this);
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class CaptionConfig {
        private final boolean required;
        private final Pattern pattern;
        private final Integer minLength;
        private final Integer maxLength;
        private final Severity severity;

        private CaptionConfig(Builder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaptionConfig that = (CaptionConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.minLength, this.maxLength, this.severity});
        }

        public String toString() {
            return "CaptionConfig{required=" + this.required + ", pattern=" + (this.pattern == null ? null : this.pattern.pattern()) + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", severity=" + String.valueOf((Object)this.severity) + "}";
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private boolean required = false;
            private Pattern pattern;
            private Integer minLength;
            private Integer maxLength;
            private Severity severity;

            @JsonProperty(value="required")
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            @JsonProperty(value="pattern")
            public Builder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            @JsonProperty(value="minLength")
            public Builder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            @JsonProperty(value="maxLength")
            public Builder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            @JsonProperty(value="severity")
            public Builder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public CaptionConfig build() {
                return new CaptionConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class CollapsibleConfig {
        private final boolean required;
        private final List<Boolean> allowed;
        private final Severity severity;

        private CollapsibleConfig(Builder builder) {
            this.required = builder.required;
            this.allowed = builder.allowed;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<Boolean> getAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollapsibleConfig that = (CollapsibleConfig)o;
            return this.required == that.required && Objects.equals(this.allowed, that.allowed) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.allowed, this.severity});
        }

        public String toString() {
            return "CollapsibleConfig{required=" + this.required + ", allowed=" + String.valueOf(this.allowed) + ", severity=" + String.valueOf((Object)this.severity) + "}";
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private boolean required = false;
            private List<Boolean> allowed;
            private Severity severity;

            @JsonProperty(value="required")
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            @JsonProperty(value="allowed")
            public Builder allowed(List<Boolean> allowed) {
                this.allowed = allowed;
                return this;
            }

            @JsonProperty(value="severity")
            public Builder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public CollapsibleConfig build() {
                return new CollapsibleConfig(this);
            }
        }
    }
}

