/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class ImageBlock
extends AbstractBlock {
    @JsonProperty(value="url")
    private final UrlConfig url;
    @JsonProperty(value="height")
    private final DimensionConfig height;
    @JsonProperty(value="width")
    private final DimensionConfig width;
    @JsonProperty(value="alt")
    private final AltTextConfig alt;

    private ImageBlock(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.height = builder.height;
        this.width = builder.width;
        this.alt = builder.alt;
    }

    @Override
    public BlockType getType() {
        return BlockType.IMAGE;
    }

    public UrlConfig getUrl() {
        return this.url;
    }

    public DimensionConfig getHeight() {
        return this.height;
    }

    public DimensionConfig getWidth() {
        return this.width;
    }

    public AltTextConfig getAlt() {
        return this.alt;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageBlock)) {
            return false;
        }
        ImageBlock that = (ImageBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.url, that.url) && Objects.equals(this.height, that.height) && Objects.equals(this.width, that.width) && Objects.equals(this.alt, that.alt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url, this.height, this.width, this.alt);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private UrlConfig url;
        private DimensionConfig height;
        private DimensionConfig width;
        private AltTextConfig alt;

        public Builder url(UrlConfig url) {
            this.url = url;
            return this;
        }

        public Builder height(DimensionConfig height) {
            this.height = height;
            return this;
        }

        public Builder width(DimensionConfig width) {
            this.width = width;
            return this;
        }

        public Builder alt(AltTextConfig alt) {
            this.alt = alt;
            return this;
        }

        @Override
        public ImageBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new ImageBlock(this);
        }
    }

    @JsonDeserialize(builder=UrlConfigBuilder.class)
    public static class UrlConfig {
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="required")
        private final boolean required;

        private UrlConfig(UrlConfigBuilder builder) {
            this.pattern = builder.pattern;
            this.required = builder.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public boolean isRequired() {
            return this.required;
        }

        public static UrlConfigBuilder builder() {
            return new UrlConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrlConfig)) {
                return false;
            }
            UrlConfig that = (UrlConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern());
        }

        public int hashCode() {
            return Objects.hash(this.pattern == null ? null : this.pattern.pattern(), this.required);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class UrlConfigBuilder {
            private Pattern pattern;
            private boolean required;

            public UrlConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public UrlConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public UrlConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public UrlConfig build() {
                return new UrlConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=DimensionConfigBuilder.class)
    public static class DimensionConfig {
        @JsonProperty(value="minValue")
        private final Integer minValue;
        @JsonProperty(value="maxValue")
        private final Integer maxValue;
        @JsonProperty(value="required")
        private final boolean required;

        private DimensionConfig(DimensionConfigBuilder builder) {
            this.minValue = builder.minValue;
            this.maxValue = builder.maxValue;
            this.required = builder.required;
        }

        public Integer getMinValue() {
            return this.minValue;
        }

        public Integer getMaxValue() {
            return this.maxValue;
        }

        public boolean isRequired() {
            return this.required;
        }

        public static DimensionConfigBuilder builder() {
            return new DimensionConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DimensionConfig)) {
                return false;
            }
            DimensionConfig that = (DimensionConfig)o;
            return this.required == that.required && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue);
        }

        public int hashCode() {
            return Objects.hash(this.minValue, this.maxValue, this.required);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class DimensionConfigBuilder {
            private Integer minValue;
            private Integer maxValue;
            private boolean required;

            public DimensionConfigBuilder minValue(Integer minValue) {
                this.minValue = minValue;
                return this;
            }

            public DimensionConfigBuilder maxValue(Integer maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public DimensionConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public DimensionConfig build() {
                return new DimensionConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=AltTextConfigBuilder.class)
    public static class AltTextConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;

        private AltTextConfig(AltTextConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public static AltTextConfigBuilder builder() {
            return new AltTextConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AltTextConfig)) {
                return false;
            }
            AltTextConfig that = (AltTextConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength);
        }

        public int hashCode() {
            return Objects.hash(this.required, this.minLength, this.maxLength);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class AltTextConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;

            public AltTextConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public AltTextConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public AltTextConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public AltTextConfig build() {
                return new AltTextConfig(this);
            }
        }
    }
}

