/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.dataliquid.asciidoc.linter.config.rule.LineConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class ListingBlock
extends AbstractBlock {
    @JsonProperty(value="language")
    private final LanguageConfig language;
    @JsonProperty(value="lines")
    private final LineConfig lines;
    @JsonProperty(value="title")
    private final TitleConfig title;
    @JsonProperty(value="callouts")
    private final CalloutsConfig callouts;

    private ListingBlock(Builder builder) {
        super(builder);
        this.language = builder.language;
        this.lines = builder.lines;
        this.title = builder.title;
        this.callouts = builder.callouts;
    }

    @Override
    public BlockType getType() {
        return BlockType.LISTING;
    }

    public LanguageConfig getLanguage() {
        return this.language;
    }

    public LineConfig getLines() {
        return this.lines;
    }

    public TitleConfig getTitle() {
        return this.title;
    }

    public CalloutsConfig getCallouts() {
        return this.callouts;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListingBlock)) {
            return false;
        }
        ListingBlock that = (ListingBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.language, that.language) && Objects.equals(this.lines, that.lines) && Objects.equals(this.title, that.title) && Objects.equals(this.callouts, that.callouts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.language, this.lines, this.title, this.callouts);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private LanguageConfig language;
        private LineConfig lines;
        private TitleConfig title;
        private CalloutsConfig callouts;

        public Builder language(LanguageConfig language) {
            this.language = language;
            return this;
        }

        public Builder lines(LineConfig lines) {
            this.lines = lines;
            return this;
        }

        public Builder title(TitleConfig title) {
            this.title = title;
            return this;
        }

        public Builder callouts(CalloutsConfig callouts) {
            this.callouts = callouts;
            return this;
        }

        @Override
        public ListingBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new ListingBlock(this);
        }
    }

    @JsonDeserialize(builder=LanguageConfigBuilder.class)
    public static class LanguageConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="allowed")
        private final List<String> allowed;
        @JsonProperty(value="severity")
        private final Severity severity;

        private LanguageConfig(LanguageConfigBuilder builder) {
            this.required = builder.required;
            this.allowed = builder.allowed != null ? Collections.unmodifiableList(new ArrayList<String>(builder.allowed)) : Collections.emptyList();
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<String> getAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static LanguageConfigBuilder builder() {
            return new LanguageConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LanguageConfig)) {
                return false;
            }
            LanguageConfig that = (LanguageConfig)o;
            return this.required == that.required && Objects.equals(this.allowed, that.allowed) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.allowed, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class LanguageConfigBuilder {
            private boolean required;
            private List<String> allowed;
            private Severity severity;

            public LanguageConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public LanguageConfigBuilder allowed(List<String> allowed) {
                this.allowed = allowed;
                return this;
            }

            public LanguageConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public LanguageConfig build() {
                return new LanguageConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=TitleConfigBuilder.class)
    public static class TitleConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TitleConfig(TitleConfigBuilder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TitleConfigBuilder builder() {
            return new TitleConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TitleConfig)) {
                return false;
            }
            TitleConfig that = (TitleConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TitleConfigBuilder {
            private boolean required;
            private Pattern pattern;
            private Severity severity;

            public TitleConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TitleConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public TitleConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public TitleConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TitleConfig build() {
                return new TitleConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=CalloutsConfigBuilder.class)
    public static class CalloutsConfig {
        @JsonProperty(value="allowed")
        private final boolean allowed;
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private CalloutsConfig(CalloutsConfigBuilder builder) {
            this.allowed = builder.allowed;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static CalloutsConfigBuilder builder() {
            return new CalloutsConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CalloutsConfig)) {
                return false;
            }
            CalloutsConfig that = (CalloutsConfig)o;
            return this.allowed == that.allowed && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.allowed, this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class CalloutsConfigBuilder {
            private boolean allowed;
            private Integer max;
            private Severity severity;

            public CalloutsConfigBuilder allowed(boolean allowed) {
                this.allowed = allowed;
                return this;
            }

            public CalloutsConfigBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            public CalloutsConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public CalloutsConfig build() {
                return new CalloutsConfig(this);
            }
        }
    }
}

