/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class LiteralBlock
extends AbstractBlock {
    @JsonProperty(value="title")
    private final TitleConfig title;
    @JsonProperty(value="lines")
    private final LinesConfig lines;
    @JsonProperty(value="indentation")
    private final IndentationConfig indentation;

    private LiteralBlock(Builder builder) {
        super(builder);
        this.title = builder.title;
        this.lines = builder.lines;
        this.indentation = builder.indentation;
    }

    @Override
    public BlockType getType() {
        return BlockType.LITERAL;
    }

    public TitleConfig getTitle() {
        return this.title;
    }

    public LinesConfig getLines() {
        return this.lines;
    }

    public IndentationConfig getIndentation() {
        return this.indentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralBlock)) {
            return false;
        }
        LiteralBlock that = (LiteralBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.title, that.title) && Objects.equals(this.lines, that.lines) && Objects.equals(this.indentation, that.indentation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.lines, this.indentation);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private TitleConfig title;
        private LinesConfig lines;
        private IndentationConfig indentation;

        public Builder title(TitleConfig title) {
            this.title = title;
            return this;
        }

        public Builder lines(LinesConfig lines) {
            this.lines = lines;
            return this;
        }

        public Builder indentation(IndentationConfig indentation) {
            this.indentation = indentation;
            return this;
        }

        @Override
        public LiteralBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new LiteralBlock(this);
        }
    }

    @JsonDeserialize(builder=TitleConfigBuilder.class)
    public static class TitleConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TitleConfig(TitleConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TitleConfigBuilder builder() {
            return new TitleConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TitleConfig)) {
                return false;
            }
            TitleConfig that = (TitleConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TitleConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;
            private Severity severity;

            public TitleConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TitleConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public TitleConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public TitleConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TitleConfig build() {
                return new TitleConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=LinesConfigBuilder.class)
    public static class LinesConfig {
        @JsonProperty(value="min")
        private final Integer min;
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private LinesConfig(LinesConfigBuilder builder) {
            this.min = builder.min;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static LinesConfigBuilder builder() {
            return new LinesConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinesConfig)) {
                return false;
            }
            LinesConfig that = (LinesConfig)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.min, this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class LinesConfigBuilder {
            private Integer min;
            private Integer max;
            private Severity severity;

            public LinesConfigBuilder min(Integer min) {
                this.min = min;
                return this;
            }

            public LinesConfigBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            public LinesConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public LinesConfig build() {
                return new LinesConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=IndentationConfigBuilder.class)
    public static class IndentationConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="consistent")
        private final boolean consistent;
        @JsonProperty(value="minSpaces")
        private final Integer minSpaces;
        @JsonProperty(value="maxSpaces")
        private final Integer maxSpaces;
        @JsonProperty(value="severity")
        private final Severity severity;

        private IndentationConfig(IndentationConfigBuilder builder) {
            this.required = builder.required;
            this.consistent = builder.consistent;
            this.minSpaces = builder.minSpaces;
            this.maxSpaces = builder.maxSpaces;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isConsistent() {
            return this.consistent;
        }

        public Integer getMinSpaces() {
            return this.minSpaces;
        }

        public Integer getMaxSpaces() {
            return this.maxSpaces;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static IndentationConfigBuilder builder() {
            return new IndentationConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndentationConfig)) {
                return false;
            }
            IndentationConfig that = (IndentationConfig)o;
            return this.required == that.required && this.consistent == that.consistent && Objects.equals(this.minSpaces, that.minSpaces) && Objects.equals(this.maxSpaces, that.maxSpaces) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.consistent, this.minSpaces, this.maxSpaces, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class IndentationConfigBuilder {
            private boolean required;
            private boolean consistent;
            private Integer minSpaces;
            private Integer maxSpaces;
            private Severity severity;

            public IndentationConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public IndentationConfigBuilder consistent(boolean consistent) {
                this.consistent = consistent;
                return this;
            }

            public IndentationConfigBuilder minSpaces(Integer minSpaces) {
                this.minSpaces = minSpaces;
                return this;
            }

            public IndentationConfigBuilder maxSpaces(Integer maxSpaces) {
                this.maxSpaces = maxSpaces;
                return this;
            }

            public IndentationConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public IndentationConfig build() {
                return new IndentationConfig(this);
            }
        }
    }
}

