/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.dataliquid.asciidoc.linter.config.rule.LineConfig;
import com.dataliquid.asciidoc.linter.config.rule.OccurrenceConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ParagraphBlock
extends AbstractBlock {
    @JsonProperty(value="lines")
    private final LineConfig lines;
    @JsonProperty(value="sentence")
    private final SentenceConfig sentence;

    private ParagraphBlock(Builder builder) {
        super(builder);
        this.lines = builder.lines;
        this.sentence = builder.sentence;
    }

    @Override
    public BlockType getType() {
        return BlockType.PARAGRAPH;
    }

    public LineConfig getLines() {
        return this.lines;
    }

    public SentenceConfig getSentence() {
        return this.sentence;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParagraphBlock that = (ParagraphBlock)o;
        return Objects.equals(this.lines, that.lines) && Objects.equals(this.sentence, that.sentence);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lines, this.sentence);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private LineConfig lines;
        private SentenceConfig sentence;

        public Builder lines(LineConfig lines) {
            this.lines = lines;
            return this;
        }

        public Builder sentence(SentenceConfig sentence) {
            this.sentence = sentence;
            return this;
        }

        @Override
        public ParagraphBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new ParagraphBlock(this);
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static final class SentenceConfig {
        @JsonProperty(value="occurrence")
        private final OccurrenceConfig occurrence;
        @JsonProperty(value="words")
        private final WordsConfig words;

        private SentenceConfig(Builder builder) {
            this.occurrence = builder.occurrence;
            this.words = builder.words;
        }

        public OccurrenceConfig getOccurrence() {
            return this.occurrence;
        }

        public WordsConfig getWords() {
            return this.words;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SentenceConfig that = (SentenceConfig)o;
            return Objects.equals(this.occurrence, that.occurrence) && Objects.equals(this.words, that.words);
        }

        public int hashCode() {
            return Objects.hash(this.occurrence, this.words);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private OccurrenceConfig occurrence;
            private WordsConfig words;

            @JsonProperty(value="occurrence")
            public Builder occurrence(OccurrenceConfig occurrence) {
                this.occurrence = occurrence;
                return this;
            }

            @JsonProperty(value="words")
            public Builder words(WordsConfig words) {
                this.words = words;
                return this;
            }

            public SentenceConfig build() {
                return new SentenceConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static final class WordsConfig {
        @JsonProperty(value="min")
        private final Integer min;
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private WordsConfig(Builder builder) {
            this.min = builder.min;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WordsConfig that = (WordsConfig)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.min, this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private Integer min;
            private Integer max;
            private Severity severity;

            @JsonProperty(value="min")
            public Builder min(Integer min) {
                this.min = min;
                return this;
            }

            @JsonProperty(value="max")
            public Builder max(Integer max) {
                this.max = max;
                return this;
            }

            @JsonProperty(value="severity")
            public Builder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public WordsConfig build() {
                return new WordsConfig(this);
            }
        }
    }
}

