/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class PassBlock
extends AbstractBlock {
    @JsonProperty(value="type")
    private final TypeConfig type;
    @JsonProperty(value="content")
    private final ContentConfig content;
    @JsonProperty(value="reason")
    private final ReasonConfig reason;

    private PassBlock(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.content = builder.content;
        this.reason = builder.reason;
    }

    @Override
    public BlockType getType() {
        return BlockType.PASS;
    }

    public TypeConfig getTypeConfig() {
        return this.type;
    }

    public ContentConfig getContent() {
        return this.content;
    }

    public ReasonConfig getReason() {
        return this.reason;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PassBlock)) {
            return false;
        }
        PassBlock that = (PassBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.type, that.type) && Objects.equals(this.content, that.content) && Objects.equals(this.reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.content, this.reason);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private TypeConfig type;
        private ContentConfig content;
        private ReasonConfig reason;

        public Builder type(TypeConfig type) {
            this.type = type;
            return this;
        }

        public Builder content(ContentConfig content) {
            this.content = content;
            return this;
        }

        public Builder reason(ReasonConfig reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public PassBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new PassBlock(this);
        }
    }

    @JsonDeserialize(builder=TypeConfigBuilder.class)
    public static class TypeConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="allowed")
        private final List<String> allowed;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TypeConfig(TypeConfigBuilder builder) {
            this.required = builder.required;
            this.allowed = builder.allowed != null ? Collections.unmodifiableList(new ArrayList<String>(builder.allowed)) : Collections.emptyList();
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<String> getAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TypeConfigBuilder builder() {
            return new TypeConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeConfig)) {
                return false;
            }
            TypeConfig that = (TypeConfig)o;
            return this.required == that.required && Objects.equals(this.allowed, that.allowed) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.allowed, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TypeConfigBuilder {
            private boolean required;
            private List<String> allowed;
            private Severity severity;

            public TypeConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TypeConfigBuilder allowed(List<String> allowed) {
                this.allowed = allowed;
                return this;
            }

            public TypeConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TypeConfig build() {
                return new TypeConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=ContentConfigBuilder.class)
    public static class ContentConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="severity")
        private final Severity severity;

        private ContentConfig(ContentConfigBuilder builder) {
            this.required = builder.required;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static ContentConfigBuilder builder() {
            return new ContentConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentConfig)) {
                return false;
            }
            ContentConfig that = (ContentConfig)o;
            return this.required == that.required && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.maxLength, this.pattern == null ? null : this.pattern.pattern(), this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ContentConfigBuilder {
            private boolean required;
            private Integer maxLength;
            private Pattern pattern;
            private Severity severity;

            public ContentConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public ContentConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public ContentConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public ContentConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public ContentConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public ContentConfig build() {
                return new ContentConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=ReasonConfigBuilder.class)
    public static class ReasonConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="severity")
        private final Severity severity;

        private ReasonConfig(ReasonConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static ReasonConfigBuilder builder() {
            return new ReasonConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReasonConfig)) {
                return false;
            }
            ReasonConfig that = (ReasonConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ReasonConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;
            private Severity severity;

            public ReasonConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public ReasonConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public ReasonConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public ReasonConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public ReasonConfig build() {
                return new ReasonConfig(this);
            }
        }
    }
}

