/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public class QuoteBlock
extends AbstractBlock {
    private final AuthorConfig author;
    private final SourceConfig source;
    private final ContentConfig content;

    private QuoteBlock(Builder builder) {
        super(builder);
        this.author = builder.author;
        this.source = builder.source;
        this.content = builder.content;
    }

    @Override
    public BlockType getType() {
        return BlockType.QUOTE;
    }

    @JsonProperty(value="author")
    public AuthorConfig getAuthor() {
        return this.author;
    }

    @JsonProperty(value="source")
    public SourceConfig getSource() {
        return this.source;
    }

    @JsonProperty(value="content")
    public ContentConfig getContent() {
        return this.content;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuoteBlock that = (QuoteBlock)o;
        return Objects.equals(this.author, that.author) && Objects.equals(this.source, that.source) && Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.author, this.source, this.content);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private AuthorConfig author;
        private SourceConfig source;
        private ContentConfig content;

        @JsonProperty(value="author")
        public Builder author(AuthorConfig author) {
            this.author = author;
            return this;
        }

        @JsonProperty(value="source")
        public Builder source(SourceConfig source) {
            this.source = source;
            return this;
        }

        @JsonProperty(value="content")
        public Builder content(ContentConfig content) {
            this.content = content;
            return this;
        }

        @Override
        public QuoteBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new QuoteBlock(this);
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class AuthorConfig {
        private final boolean required;
        private final Integer minLength;
        private final Integer maxLength;
        private final Pattern pattern;
        private final Severity severity;

        private AuthorConfig(Builder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        @JsonProperty(value="required")
        public boolean isRequired() {
            return this.required;
        }

        @JsonProperty(value="minLength")
        public Integer getMinLength() {
            return this.minLength;
        }

        @JsonProperty(value="maxLength")
        public Integer getMaxLength() {
            return this.maxLength;
        }

        @JsonProperty(value="pattern")
        public Pattern getPattern() {
            return this.pattern;
        }

        @JsonProperty(value="severity")
        public Severity getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthorConfig that = (AuthorConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.patternEquals(this.pattern, that.pattern) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.pattern != null ? this.pattern.pattern() : null, this.severity});
        }

        private boolean patternEquals(Pattern p1, Pattern p2) {
            if (p1 == p2) {
                return true;
            }
            if (p1 == null || p2 == null) {
                return false;
            }
            return p1.pattern().equals(p2.pattern());
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private boolean required = false;
            private Integer minLength;
            private Integer maxLength;
            private Pattern pattern;
            private Severity severity;

            @JsonProperty(value="required")
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            @JsonProperty(value="minLength")
            public Builder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            @JsonProperty(value="maxLength")
            public Builder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            @JsonProperty(value="pattern")
            public Builder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            @JsonProperty(value="severity")
            public Builder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public AuthorConfig build() {
                return new AuthorConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class SourceConfig {
        private final boolean required;
        private final Integer minLength;
        private final Integer maxLength;
        private final Pattern pattern;
        private final Severity severity;

        private SourceConfig(Builder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        @JsonProperty(value="required")
        public boolean isRequired() {
            return this.required;
        }

        @JsonProperty(value="minLength")
        public Integer getMinLength() {
            return this.minLength;
        }

        @JsonProperty(value="maxLength")
        public Integer getMaxLength() {
            return this.maxLength;
        }

        @JsonProperty(value="pattern")
        public Pattern getPattern() {
            return this.pattern;
        }

        @JsonProperty(value="severity")
        public Severity getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceConfig that = (SourceConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.patternEquals(this.pattern, that.pattern) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.pattern != null ? this.pattern.pattern() : null, this.severity});
        }

        private boolean patternEquals(Pattern p1, Pattern p2) {
            if (p1 == p2) {
                return true;
            }
            if (p1 == null || p2 == null) {
                return false;
            }
            return p1.pattern().equals(p2.pattern());
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private boolean required = false;
            private Integer minLength;
            private Integer maxLength;
            private Pattern pattern;
            private Severity severity;

            @JsonProperty(value="required")
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            @JsonProperty(value="minLength")
            public Builder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            @JsonProperty(value="maxLength")
            public Builder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            @JsonProperty(value="pattern")
            public Builder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            @JsonProperty(value="severity")
            public Builder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public SourceConfig build() {
                return new SourceConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class ContentConfig {
        private final boolean required;
        private final Integer minLength;
        private final Integer maxLength;
        private final LinesConfig lines;

        private ContentConfig(Builder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.lines = builder.lines;
        }

        @JsonProperty(value="required")
        public boolean isRequired() {
            return this.required;
        }

        @JsonProperty(value="minLength")
        public Integer getMinLength() {
            return this.minLength;
        }

        @JsonProperty(value="maxLength")
        public Integer getMaxLength() {
            return this.maxLength;
        }

        @JsonProperty(value="lines")
        public LinesConfig getLines() {
            return this.lines;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentConfig that = (ContentConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.lines, that.lines);
        }

        public int hashCode() {
            return Objects.hash(this.required, this.minLength, this.maxLength, this.lines);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private boolean required = false;
            private Integer minLength;
            private Integer maxLength;
            private LinesConfig lines;

            @JsonProperty(value="required")
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            @JsonProperty(value="minLength")
            public Builder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            @JsonProperty(value="maxLength")
            public Builder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            @JsonProperty(value="lines")
            public Builder lines(LinesConfig lines) {
                this.lines = lines;
                return this;
            }

            public ContentConfig build() {
                return new ContentConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class LinesConfig {
        private final Integer min;
        private final Integer max;
        private final Severity severity;

        private LinesConfig(Builder builder) {
            this.min = builder.min;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        @JsonProperty(value="min")
        public Integer getMin() {
            return this.min;
        }

        @JsonProperty(value="max")
        public Integer getMax() {
            return this.max;
        }

        @JsonProperty(value="severity")
        public Severity getSeverity() {
            return this.severity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinesConfig that = (LinesConfig)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.min, this.max, this.severity});
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private Integer min;
            private Integer max;
            private Severity severity;

            @JsonProperty(value="min")
            public Builder min(Integer min) {
                this.min = min;
                return this;
            }

            @JsonProperty(value="max")
            public Builder max(Integer max) {
                this.max = max;
                return this;
            }

            @JsonProperty(value="severity")
            public Builder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public LinesConfig build() {
                return new LinesConfig(this);
            }
        }
    }
}

