/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class SidebarBlock
extends AbstractBlock {
    @JsonProperty(value="title")
    private final TitleConfig title;
    @JsonProperty(value="content")
    private final ContentConfig content;
    @JsonProperty(value="position")
    private final PositionConfig position;

    private SidebarBlock(Builder builder) {
        super(builder);
        this.title = builder.title;
        this.content = builder.content;
        this.position = builder.position;
    }

    @Override
    public BlockType getType() {
        return BlockType.SIDEBAR;
    }

    public TitleConfig getTitle() {
        return this.title;
    }

    public ContentConfig getContent() {
        return this.content;
    }

    public PositionConfig getPosition() {
        return this.position;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SidebarBlock)) {
            return false;
        }
        SidebarBlock that = (SidebarBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.title, that.title) && Objects.equals(this.content, that.content) && Objects.equals(this.position, that.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.content, this.position);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private TitleConfig title;
        private ContentConfig content;
        private PositionConfig position;

        public Builder title(TitleConfig title) {
            this.title = title;
            return this;
        }

        public Builder content(ContentConfig content) {
            this.content = content;
            return this;
        }

        public Builder position(PositionConfig position) {
            this.position = position;
            return this;
        }

        @Override
        public SidebarBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new SidebarBlock(this);
        }
    }

    @JsonDeserialize(builder=TitleConfigBuilder.class)
    public static class TitleConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TitleConfig(TitleConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TitleConfigBuilder builder() {
            return new TitleConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TitleConfig)) {
                return false;
            }
            TitleConfig that = (TitleConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern != null ? this.pattern.pattern() : null, that.pattern != null ? that.pattern.pattern() : null) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.pattern != null ? this.pattern.pattern() : null, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TitleConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;
            private Pattern pattern;
            private Severity severity;

            public TitleConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TitleConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public TitleConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public TitleConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public TitleConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public TitleConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TitleConfig build() {
                return new TitleConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=ContentConfigBuilder.class)
    public static class ContentConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="lines")
        private final LinesConfig lines;

        private ContentConfig(ContentConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.lines = builder.lines;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public LinesConfig getLines() {
            return this.lines;
        }

        public static ContentConfigBuilder builder() {
            return new ContentConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentConfig)) {
                return false;
            }
            ContentConfig that = (ContentConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.lines, that.lines);
        }

        public int hashCode() {
            return Objects.hash(this.required, this.minLength, this.maxLength, this.lines);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ContentConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;
            private LinesConfig lines;

            public ContentConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public ContentConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public ContentConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public ContentConfigBuilder lines(LinesConfig lines) {
                this.lines = lines;
                return this;
            }

            public ContentConfig build() {
                return new ContentConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=PositionConfigBuilder.class)
    public static class PositionConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="allowed")
        private final List<String> allowed;
        @JsonProperty(value="severity")
        private final Severity severity;

        private PositionConfig(PositionConfigBuilder builder) {
            this.required = builder.required;
            this.allowed = builder.allowed;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<String> getAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static PositionConfigBuilder builder() {
            return new PositionConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PositionConfig)) {
                return false;
            }
            PositionConfig that = (PositionConfig)o;
            return this.required == that.required && Objects.equals(this.allowed, that.allowed) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.allowed, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class PositionConfigBuilder {
            private boolean required;
            private List<String> allowed;
            private Severity severity;

            public PositionConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public PositionConfigBuilder allowed(List<String> allowed) {
                this.allowed = allowed;
                return this;
            }

            public PositionConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public PositionConfig build() {
                return new PositionConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=LinesConfigBuilder.class)
    public static class LinesConfig {
        @JsonProperty(value="min")
        private final Integer min;
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private LinesConfig(LinesConfigBuilder builder) {
            this.min = builder.min;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static LinesConfigBuilder builder() {
            return new LinesConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinesConfig)) {
                return false;
            }
            LinesConfig that = (LinesConfig)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.min, this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class LinesConfigBuilder {
            private Integer min;
            private Integer max;
            private Severity severity;

            public LinesConfigBuilder min(Integer min) {
                this.min = min;
                return this;
            }

            public LinesConfigBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            public LinesConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public LinesConfig build() {
                return new LinesConfig(this);
            }
        }
    }
}

