/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class TableBlock
extends AbstractBlock {
    @JsonProperty(value="columns")
    private final DimensionConfig columns;
    @JsonProperty(value="rows")
    private final DimensionConfig rows;
    @JsonProperty(value="header")
    private final HeaderConfig header;
    @JsonProperty(value="caption")
    private final CaptionConfig caption;
    @JsonProperty(value="format")
    private final FormatConfig format;

    private TableBlock(Builder builder) {
        super(builder);
        this.columns = builder.columns;
        this.rows = builder.rows;
        this.header = builder.header;
        this.caption = builder.caption;
        this.format = builder.format;
    }

    @Override
    public BlockType getType() {
        return BlockType.TABLE;
    }

    public DimensionConfig getColumns() {
        return this.columns;
    }

    public DimensionConfig getRows() {
        return this.rows;
    }

    public HeaderConfig getHeader() {
        return this.header;
    }

    public CaptionConfig getCaption() {
        return this.caption;
    }

    public FormatConfig getFormat() {
        return this.format;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableBlock)) {
            return false;
        }
        TableBlock that = (TableBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows) && Objects.equals(this.header, that.header) && Objects.equals(this.caption, that.caption) && Objects.equals(this.format, that.format);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.columns, this.rows, this.header, this.caption, this.format);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private DimensionConfig columns;
        private DimensionConfig rows;
        private HeaderConfig header;
        private CaptionConfig caption;
        private FormatConfig format;

        public Builder columns(DimensionConfig columns) {
            this.columns = columns;
            return this;
        }

        public Builder rows(DimensionConfig rows) {
            this.rows = rows;
            return this;
        }

        public Builder header(HeaderConfig header) {
            this.header = header;
            return this;
        }

        public Builder caption(CaptionConfig caption) {
            this.caption = caption;
            return this;
        }

        public Builder format(FormatConfig format) {
            this.format = format;
            return this;
        }

        @Override
        public TableBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new TableBlock(this);
        }
    }

    @JsonDeserialize(builder=DimensionConfigBuilder.class)
    public static class DimensionConfig {
        @JsonProperty(value="min")
        private final Integer min;
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private DimensionConfig(DimensionConfigBuilder builder) {
            this.min = builder.min;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static DimensionConfigBuilder builder() {
            return new DimensionConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DimensionConfig)) {
                return false;
            }
            DimensionConfig that = (DimensionConfig)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.min, this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class DimensionConfigBuilder {
            private Integer min;
            private Integer max;
            private Severity severity;

            public DimensionConfigBuilder min(Integer min) {
                this.min = min;
                return this;
            }

            public DimensionConfigBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            public DimensionConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public DimensionConfig build() {
                return new DimensionConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=HeaderConfigBuilder.class)
    public static class HeaderConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="severity")
        private final Severity severity;

        private HeaderConfig(HeaderConfigBuilder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static HeaderConfigBuilder builder() {
            return new HeaderConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeaderConfig)) {
                return false;
            }
            HeaderConfig that = (HeaderConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class HeaderConfigBuilder {
            private boolean required;
            private Pattern pattern;
            private Severity severity;

            public HeaderConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public HeaderConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public HeaderConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public HeaderConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public HeaderConfig build() {
                return new HeaderConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=CaptionConfigBuilder.class)
    public static class CaptionConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="severity")
        private final Severity severity;

        private CaptionConfig(CaptionConfigBuilder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static CaptionConfigBuilder builder() {
            return new CaptionConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CaptionConfig)) {
                return false;
            }
            CaptionConfig that = (CaptionConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.minLength, this.maxLength, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class CaptionConfigBuilder {
            private boolean required;
            private Pattern pattern;
            private Integer minLength;
            private Integer maxLength;
            private Severity severity;

            public CaptionConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public CaptionConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public CaptionConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public CaptionConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public CaptionConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public CaptionConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public CaptionConfig build() {
                return new CaptionConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=FormatConfigBuilder.class)
    public static class FormatConfig {
        @JsonProperty(value="style")
        private final String style;
        @JsonProperty(value="borders")
        private final Boolean borders;
        @JsonProperty(value="severity")
        private final Severity severity;

        private FormatConfig(FormatConfigBuilder builder) {
            this.style = builder.style;
            this.borders = builder.borders;
            this.severity = builder.severity;
        }

        public String getStyle() {
            return this.style;
        }

        public Boolean getBorders() {
            return this.borders;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static FormatConfigBuilder builder() {
            return new FormatConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FormatConfig)) {
                return false;
            }
            FormatConfig that = (FormatConfig)o;
            return Objects.equals(this.style, that.style) && Objects.equals(this.borders, that.borders) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.style, this.borders, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class FormatConfigBuilder {
            private String style;
            private Boolean borders;
            private Severity severity;

            public FormatConfigBuilder style(String style) {
                this.style = style;
                return this;
            }

            public FormatConfigBuilder borders(Boolean borders) {
                this.borders = borders;
                return this;
            }

            public FormatConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public FormatConfig build() {
                return new FormatConfig(this);
            }
        }
    }
}

