/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class UlistBlock
extends AbstractBlock {
    @JsonProperty(value="items")
    private final ItemsConfig items;
    @JsonProperty(value="nestingLevel")
    private final NestingLevelConfig nestingLevel;
    @JsonProperty(value="markerStyle")
    private final String markerStyle;

    private UlistBlock(Builder builder) {
        super(builder);
        this.items = builder.items;
        this.nestingLevel = builder.nestingLevel;
        this.markerStyle = builder.markerStyle;
    }

    @Override
    public BlockType getType() {
        return BlockType.ULIST;
    }

    public ItemsConfig getItems() {
        return this.items;
    }

    public NestingLevelConfig getNestingLevel() {
        return this.nestingLevel;
    }

    public String getMarkerStyle() {
        return this.markerStyle;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UlistBlock)) {
            return false;
        }
        UlistBlock that = (UlistBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.items, that.items) && Objects.equals(this.nestingLevel, that.nestingLevel) && Objects.equals(this.markerStyle, that.markerStyle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.items, this.nestingLevel, this.markerStyle);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private ItemsConfig items;
        private NestingLevelConfig nestingLevel;
        private String markerStyle;

        public Builder items(ItemsConfig items) {
            this.items = items;
            return this;
        }

        public Builder nestingLevel(NestingLevelConfig nestingLevel) {
            this.nestingLevel = nestingLevel;
            return this;
        }

        public Builder markerStyle(String markerStyle) {
            this.markerStyle = markerStyle;
            return this;
        }

        @Override
        public UlistBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new UlistBlock(this);
        }
    }

    @JsonDeserialize(builder=ItemsConfigBuilder.class)
    public static class ItemsConfig {
        @JsonProperty(value="min")
        private final Integer min;
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private ItemsConfig(ItemsConfigBuilder builder) {
            this.min = builder.min;
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static ItemsConfigBuilder builder() {
            return new ItemsConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemsConfig)) {
                return false;
            }
            ItemsConfig that = (ItemsConfig)o;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.min, this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ItemsConfigBuilder {
            private Integer min;
            private Integer max;
            private Severity severity;

            public ItemsConfigBuilder min(Integer min) {
                this.min = min;
                return this;
            }

            public ItemsConfigBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            public ItemsConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public ItemsConfig build() {
                return new ItemsConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=NestingLevelConfigBuilder.class)
    public static class NestingLevelConfig {
        @JsonProperty(value="max")
        private final Integer max;
        @JsonProperty(value="severity")
        private final Severity severity;

        private NestingLevelConfig(NestingLevelConfigBuilder builder) {
            this.max = builder.max;
            this.severity = builder.severity;
        }

        public Integer getMax() {
            return this.max;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static NestingLevelConfigBuilder builder() {
            return new NestingLevelConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NestingLevelConfig)) {
                return false;
            }
            NestingLevelConfig that = (NestingLevelConfig)o;
            return Objects.equals(this.max, that.max) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.max, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class NestingLevelConfigBuilder {
            private Integer max;
            private Severity severity;

            public NestingLevelConfigBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            public NestingLevelConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public NestingLevelConfig build() {
                return new NestingLevelConfig(this);
            }
        }
    }
}

