/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class VerseBlock
extends AbstractBlock {
    @JsonProperty(value="author")
    private final AuthorConfig author;
    @JsonProperty(value="attribution")
    private final AttributionConfig attribution;
    @JsonProperty(value="content")
    private final ContentConfig content;

    private VerseBlock(Builder builder) {
        super(builder);
        this.author = builder.author;
        this.attribution = builder.attribution;
        this.content = builder.content;
    }

    @Override
    public BlockType getType() {
        return BlockType.VERSE;
    }

    public AuthorConfig getAuthor() {
        return this.author;
    }

    public AttributionConfig getAttribution() {
        return this.attribution;
    }

    public ContentConfig getContent() {
        return this.content;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerseBlock)) {
            return false;
        }
        VerseBlock that = (VerseBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.author, that.author) && Objects.equals(this.attribution, that.attribution) && Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.author, this.attribution, this.content);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private AuthorConfig author;
        private AttributionConfig attribution;
        private ContentConfig content;

        public Builder author(AuthorConfig author) {
            this.author = author;
            return this;
        }

        public Builder attribution(AttributionConfig attribution) {
            this.attribution = attribution;
            return this;
        }

        public Builder content(ContentConfig content) {
            this.content = content;
            return this;
        }

        @Override
        public VerseBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new VerseBlock(this);
        }
    }

    @JsonDeserialize(builder=AuthorConfigBuilder.class)
    public static class AuthorConfig {
        @JsonProperty(value="defaultValue")
        private final String defaultValue;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="required")
        private final boolean required;

        private AuthorConfig(AuthorConfigBuilder builder) {
            this.defaultValue = builder.defaultValue;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.required = builder.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public boolean isRequired() {
            return this.required;
        }

        public static AuthorConfigBuilder builder() {
            return new AuthorConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AuthorConfig)) {
                return false;
            }
            AuthorConfig that = (AuthorConfig)o;
            return this.required == that.required && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern());
        }

        public int hashCode() {
            return Objects.hash(this.defaultValue, this.minLength, this.maxLength, this.pattern == null ? null : this.pattern.pattern(), this.required);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class AuthorConfigBuilder {
            private String defaultValue;
            private Integer minLength;
            private Integer maxLength;
            private Pattern pattern;
            private boolean required;

            public AuthorConfigBuilder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public AuthorConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public AuthorConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public AuthorConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public AuthorConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public AuthorConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public AuthorConfig build() {
                return new AuthorConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=AttributionConfigBuilder.class)
    public static class AttributionConfig {
        @JsonProperty(value="defaultValue")
        private final String defaultValue;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="required")
        private final boolean required;

        private AttributionConfig(AttributionConfigBuilder builder) {
            this.defaultValue = builder.defaultValue;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.required = builder.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public boolean isRequired() {
            return this.required;
        }

        public static AttributionConfigBuilder builder() {
            return new AttributionConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributionConfig)) {
                return false;
            }
            AttributionConfig that = (AttributionConfig)o;
            return this.required == that.required && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern());
        }

        public int hashCode() {
            return Objects.hash(this.defaultValue, this.minLength, this.maxLength, this.pattern == null ? null : this.pattern.pattern(), this.required);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class AttributionConfigBuilder {
            private String defaultValue;
            private Integer minLength;
            private Integer maxLength;
            private Pattern pattern;
            private boolean required;

            public AttributionConfigBuilder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public AttributionConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public AttributionConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public AttributionConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public AttributionConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public AttributionConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public AttributionConfig build() {
                return new AttributionConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=ContentConfigBuilder.class)
    public static class ContentConfig {
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="required")
        private final boolean required;

        private ContentConfig(ContentConfigBuilder builder) {
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.pattern = builder.pattern;
            this.required = builder.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public boolean isRequired() {
            return this.required;
        }

        public static ContentConfigBuilder builder() {
            return new ContentConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentConfig)) {
                return false;
            }
            ContentConfig that = (ContentConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern());
        }

        public int hashCode() {
            return Objects.hash(this.minLength, this.maxLength, this.pattern == null ? null : this.pattern.pattern(), this.required);
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ContentConfigBuilder {
            private Integer minLength;
            private Integer maxLength;
            private Pattern pattern;
            private boolean required;

            public ContentConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public ContentConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public ContentConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public ContentConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public ContentConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public ContentConfig build() {
                return new ContentConfig(this);
            }
        }
    }
}

