/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.loader;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.dataliquid.asciidoc.linter.config.blocks.AdmonitionBlock;
import com.dataliquid.asciidoc.linter.config.blocks.AudioBlock;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.blocks.ExampleBlock;
import com.dataliquid.asciidoc.linter.config.blocks.ImageBlock;
import com.dataliquid.asciidoc.linter.config.blocks.ListingBlock;
import com.dataliquid.asciidoc.linter.config.blocks.LiteralBlock;
import com.dataliquid.asciidoc.linter.config.blocks.ParagraphBlock;
import com.dataliquid.asciidoc.linter.config.blocks.PassBlock;
import com.dataliquid.asciidoc.linter.config.blocks.QuoteBlock;
import com.dataliquid.asciidoc.linter.config.blocks.SidebarBlock;
import com.dataliquid.asciidoc.linter.config.blocks.TableBlock;
import com.dataliquid.asciidoc.linter.config.blocks.UlistBlock;
import com.dataliquid.asciidoc.linter.config.blocks.VerseBlock;
import com.dataliquid.asciidoc.linter.config.blocks.VideoBlock;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BlockListDeserializer
extends JsonDeserializer<List<Block>> {
    public List<Block> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Block> blocks = new ArrayList<Block>();
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (!node.isArray()) {
            throw new IOException("Expected array for block list");
        }
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        for (JsonNode blockNode : node) {
            if (!blockNode.isObject()) continue;
            String blockType = (String)blockNode.fieldNames().next();
            JsonNode blockData = blockNode.get(blockType);
            BlockType type = BlockType.fromValue(blockType);
            AbstractBlock block = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case BlockType.PARAGRAPH -> (ParagraphBlock)mapper.treeToValue((TreeNode)blockData, ParagraphBlock.class);
                case BlockType.LISTING -> (ListingBlock)mapper.treeToValue((TreeNode)blockData, ListingBlock.class);
                case BlockType.TABLE -> (TableBlock)mapper.treeToValue((TreeNode)blockData, TableBlock.class);
                case BlockType.IMAGE -> (ImageBlock)mapper.treeToValue((TreeNode)blockData, ImageBlock.class);
                case BlockType.VERSE -> (VerseBlock)mapper.treeToValue((TreeNode)blockData, VerseBlock.class);
                case BlockType.ADMONITION -> (AdmonitionBlock)mapper.treeToValue((TreeNode)blockData, AdmonitionBlock.class);
                case BlockType.PASS -> (PassBlock)mapper.treeToValue((TreeNode)blockData, PassBlock.class);
                case BlockType.LITERAL -> (LiteralBlock)mapper.treeToValue((TreeNode)blockData, LiteralBlock.class);
                case BlockType.AUDIO -> (AudioBlock)mapper.treeToValue((TreeNode)blockData, AudioBlock.class);
                case BlockType.QUOTE -> (QuoteBlock)mapper.treeToValue((TreeNode)blockData, QuoteBlock.class);
                case BlockType.SIDEBAR -> (SidebarBlock)mapper.treeToValue((TreeNode)blockData, SidebarBlock.class);
                case BlockType.EXAMPLE -> (ExampleBlock)mapper.treeToValue((TreeNode)blockData, ExampleBlock.class);
                case BlockType.VIDEO -> (VideoBlock)mapper.treeToValue((TreeNode)blockData, VideoBlock.class);
                case BlockType.ULIST -> (UlistBlock)mapper.treeToValue((TreeNode)blockData, UlistBlock.class);
            };
            blocks.add(block);
        }
        return blocks;
    }
}

