/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.loader;

import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.loader.ConfigurationException;
import com.dataliquid.asciidoc.linter.config.validation.RuleSchemaValidator;
import com.dataliquid.asciidoc.linter.config.validation.RuleValidationException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationLoader {
    private static final Logger logger = LogManager.getLogger(ConfigurationLoader.class);
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final RuleSchemaValidator schemaValidator;
    private final boolean skipRuleSchemaValidation;

    public ConfigurationLoader() {
        this(false);
    }

    public ConfigurationLoader(boolean skipRuleSchemaValidation) {
        this.skipRuleSchemaValidation = skipRuleSchemaValidation;
        if (!skipRuleSchemaValidation) {
            this.schemaValidator = new RuleSchemaValidator();
        } else {
            this.schemaValidator = null;
            logger.warn("Rule configuration schema validation is DISABLED");
        }
    }

    public LinterConfiguration loadConfiguration(Path configPath) throws IOException {
        if (!this.skipRuleSchemaValidation && this.schemaValidator != null) {
            try {
                this.schemaValidator.validateUserConfig(configPath);
            }
            catch (RuleValidationException e) {
                throw new ConfigurationException("User configuration does not match schema: " + e.getMessage(), e);
            }
        }
        try (InputStream inputStream = Files.newInputStream(configPath, new OpenOption[0]);){
            LinterConfiguration linterConfiguration = this.loadConfiguration(inputStream);
            return linterConfiguration;
        }
    }

    public LinterConfiguration loadConfiguration(String yamlContent) {
        if (!this.skipRuleSchemaValidation && this.schemaValidator != null) {
            try {
                this.schemaValidator.validateYamlString(yamlContent);
            }
            catch (RuleValidationException e) {
                throw new ConfigurationException("User configuration does not match schema: " + e.getMessage(), e);
            }
        }
        try {
            LinterConfiguration config = (LinterConfiguration)this.mapper.readValue(yamlContent, LinterConfiguration.class);
            if (config == null || config.document() == null) {
                throw new ConfigurationException("Missing required 'document' section in configuration");
            }
            return config;
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse YAML configuration: " + e.getMessage(), e);
        }
    }

    public LinterConfiguration loadConfiguration(InputStream inputStream) {
        try {
            LinterConfiguration config = (LinterConfiguration)this.mapper.readValue(inputStream, LinterConfiguration.class);
            if (config == null || config.document() == null) {
                throw new ConfigurationException("Missing required 'document' section in configuration");
            }
            return config;
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load configuration: " + e.getMessage(), e);
        }
    }
}

