/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.dataliquid.asciidoc.linter.config.output.HighlightStyle;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class DisplayConfig {
    private static final int DEFAULT_CONTEXT_LINES = 2;
    private static final HighlightStyle DEFAULT_HIGHLIGHT_STYLE = HighlightStyle.UNDERLINE;
    private static final boolean DEFAULT_USE_COLORS = true;
    private static final boolean DEFAULT_SHOW_LINE_NUMBERS = true;
    private static final int DEFAULT_MAX_LINE_WIDTH = 120;
    private static final boolean DEFAULT_SHOW_HEADER = true;
    private final int contextLines;
    private final HighlightStyle highlightStyle;
    private final boolean useColors;
    private final boolean showLineNumbers;
    private final int maxLineWidth;
    private final boolean showHeader;

    private DisplayConfig(Builder builder) {
        this.contextLines = builder.contextLines;
        this.highlightStyle = builder.highlightStyle;
        this.useColors = builder.useColors;
        this.showLineNumbers = builder.showLineNumbers;
        this.maxLineWidth = builder.maxLineWidth;
        this.showHeader = builder.showHeader;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    public HighlightStyle getHighlightStyle() {
        return this.highlightStyle;
    }

    public boolean isUseColors() {
        return this.useColors;
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayConfig that = (DisplayConfig)o;
        return this.contextLines == that.contextLines && this.useColors == that.useColors && this.showLineNumbers == that.showLineNumbers && this.maxLineWidth == that.maxLineWidth && this.showHeader == that.showHeader && this.highlightStyle == that.highlightStyle;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contextLines, this.highlightStyle, this.useColors, this.showLineNumbers, this.maxLineWidth, this.showHeader});
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private int contextLines = 2;
        private HighlightStyle highlightStyle = DEFAULT_HIGHLIGHT_STYLE;
        private boolean useColors = true;
        private boolean showLineNumbers = true;
        private int maxLineWidth = 120;
        private boolean showHeader = true;

        private Builder() {
        }

        @JsonProperty(value="contextLines")
        public Builder contextLines(int contextLines) {
            this.contextLines = contextLines;
            return this;
        }

        @JsonProperty(value="highlightStyle")
        public Builder highlightStyle(HighlightStyle highlightStyle) {
            this.highlightStyle = highlightStyle != null ? highlightStyle : DEFAULT_HIGHLIGHT_STYLE;
            return this;
        }

        @JsonProperty(value="useColors")
        public Builder useColors(boolean useColors) {
            this.useColors = useColors;
            return this;
        }

        @JsonProperty(value="showLineNumbers")
        public Builder showLineNumbers(boolean showLineNumbers) {
            this.showLineNumbers = showLineNumbers;
            return this;
        }

        @JsonProperty(value="maxLineWidth")
        public Builder maxLineWidth(int maxLineWidth) {
            this.maxLineWidth = maxLineWidth;
            return this;
        }

        @JsonProperty(value="showHeader")
        public Builder showHeader(boolean showHeader) {
            this.showHeader = showHeader;
            return this;
        }

        public DisplayConfig build() {
            return new DisplayConfig(this);
        }
    }
}

