/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ErrorGroupingConfig {
    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_THRESHOLD = 3;
    private final boolean enabled;
    private final int threshold;

    private ErrorGroupingConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.threshold = builder.threshold;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorGroupingConfig that = (ErrorGroupingConfig)o;
        return this.enabled == that.enabled && this.threshold == that.threshold;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.threshold);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private boolean enabled = true;
        private int threshold = 3;

        private Builder() {
        }

        @JsonProperty(value="enabled")
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @JsonProperty(value="threshold")
        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public ErrorGroupingConfig build() {
            return new ErrorGroupingConfig(this);
        }
    }
}

