/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.dataliquid.asciidoc.linter.config.output.DisplayConfig;
import com.dataliquid.asciidoc.linter.config.output.ErrorGroupingConfig;
import com.dataliquid.asciidoc.linter.config.output.OutputFormat;
import com.dataliquid.asciidoc.linter.config.output.SuggestionsConfig;
import com.dataliquid.asciidoc.linter.config.output.SummaryConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class OutputConfiguration {
    private static final OutputFormat DEFAULT_FORMAT = OutputFormat.ENHANCED;
    private final OutputFormat format;
    private final DisplayConfig display;
    private final SuggestionsConfig suggestions;
    private final ErrorGroupingConfig errorGrouping;
    private final SummaryConfig summary;

    private OutputConfiguration(Builder builder) {
        this.format = Objects.requireNonNull(builder.format, "[" + this.getClass().getName() + "] format must not be null");
        this.display = Objects.requireNonNull(builder.display, "[" + this.getClass().getName() + "] display must not be null");
        this.suggestions = Objects.requireNonNull(builder.suggestions, "[" + this.getClass().getName() + "] suggestions must not be null");
        this.errorGrouping = Objects.requireNonNull(builder.errorGrouping, "[" + this.getClass().getName() + "] errorGrouping must not be null");
        this.summary = Objects.requireNonNull(builder.summary, "[" + this.getClass().getName() + "] summary must not be null");
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public DisplayConfig getDisplay() {
        return this.display;
    }

    public SuggestionsConfig getSuggestions() {
        return this.suggestions;
    }

    public ErrorGroupingConfig getErrorGrouping() {
        return this.errorGrouping;
    }

    public SummaryConfig getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputConfiguration that = (OutputConfiguration)o;
        return this.format == that.format && Objects.equals(this.display, that.display) && Objects.equals(this.suggestions, that.suggestions) && Objects.equals(this.errorGrouping, that.errorGrouping) && Objects.equals(this.summary, that.summary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.display, this.suggestions, this.errorGrouping, this.summary});
    }

    public static OutputConfiguration defaultConfig() {
        return OutputConfiguration.builder().build();
    }

    public static OutputConfiguration compactConfig() {
        return OutputConfiguration.builder().format(OutputFormat.COMPACT).display(DisplayConfig.builder().contextLines(0).useColors(false).showHeader(false).build()).suggestions(SuggestionsConfig.builder().enabled(false).build()).errorGrouping(ErrorGroupingConfig.builder().enabled(false).build()).summary(SummaryConfig.builder().enabled(false).build()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private OutputFormat format = DEFAULT_FORMAT;
        private DisplayConfig display = DisplayConfig.builder().build();
        private SuggestionsConfig suggestions = SuggestionsConfig.builder().build();
        private ErrorGroupingConfig errorGrouping = ErrorGroupingConfig.builder().build();
        private SummaryConfig summary = SummaryConfig.builder().build();

        private Builder() {
        }

        @JsonProperty(value="format")
        public Builder format(OutputFormat format) {
            this.format = format != null ? format : DEFAULT_FORMAT;
            return this;
        }

        @JsonProperty(value="display")
        public Builder display(DisplayConfig display) {
            this.display = display != null ? display : DisplayConfig.builder().build();
            return this;
        }

        @JsonProperty(value="suggestions")
        public Builder suggestions(SuggestionsConfig suggestions) {
            this.suggestions = suggestions != null ? suggestions : SuggestionsConfig.builder().build();
            return this;
        }

        @JsonProperty(value="errorGrouping")
        public Builder errorGrouping(ErrorGroupingConfig errorGrouping) {
            this.errorGrouping = errorGrouping != null ? errorGrouping : ErrorGroupingConfig.builder().build();
            return this;
        }

        @JsonProperty(value="summary")
        public Builder summary(SummaryConfig summary) {
            this.summary = summary != null ? summary : SummaryConfig.builder().build();
            return this;
        }

        public OutputConfiguration build() {
            return new OutputConfiguration(this);
        }
    }
}

