/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.dataliquid.asciidoc.linter.config.output.OutputConfigWrapper;
import com.dataliquid.asciidoc.linter.config.output.OutputConfiguration;
import com.dataliquid.asciidoc.linter.config.output.OutputSchemaValidator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class OutputConfigurationLoader {
    private static final String SCHEMA_PATH = "/schemas/output/output-config-schema.yaml";
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final OutputSchemaValidator validator;

    public OutputConfigurationLoader() {
        this(false);
    }

    public OutputConfigurationLoader(boolean skipValidation) {
        this.validator = skipValidation ? null : new OutputSchemaValidator(SCHEMA_PATH);
    }

    public OutputConfiguration loadConfiguration(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("Configuration file not found: " + filePath);
        }
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            OutputConfiguration outputConfiguration = this.loadConfiguration(input);
            return outputConfiguration;
        }
    }

    public OutputConfiguration loadConfiguration(InputStream input) throws IOException {
        OutputConfigWrapper wrapper = (OutputConfigWrapper)this.mapper.readValue(input, OutputConfigWrapper.class);
        if (this.validator != null) {
            String yaml = this.mapper.writeValueAsString((Object)wrapper);
            this.validator.validate(yaml);
        }
        return wrapper.getOutput();
    }

    public OutputConfiguration getDefaultConfiguration() {
        return OutputConfiguration.defaultConfig();
    }

    public OutputConfiguration getCompactConfiguration() {
        return OutputConfiguration.compactConfig();
    }
}

