/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.dataliquid.asciidoc.linter.config.output.OutputConfigurationException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;

public class OutputSchemaValidator {
    private final String schemaPath;
    private final JsonSchema schema;
    private final ObjectMapper yamlMapper;

    public OutputSchemaValidator(String schemaPath) {
        this.schemaPath = schemaPath;
        this.yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.schema = this.loadSchema();
    }

    private JsonSchema loadSchema() {
        try {
            InputStream schemaStream = this.getClass().getResourceAsStream(this.schemaPath);
            if (schemaStream == null) {
                throw new OutputConfigurationException("Schema not found: " + this.schemaPath);
            }
            JsonNode schemaNode = this.yamlMapper.readTree(schemaStream);
            String baseClasspathUrl = this.getClass().getResource("/schemas/").toString();
            JsonSchemaFactory factory = JsonSchemaFactory.builder().defaultMetaSchemaIri(JsonMetaSchema.getV202012().getIri()).schemaMappers(schemaMappers -> schemaMappers.mapPrefix("https://dataliquid.com/asciidoc/linter/schemas/", baseClasspathUrl)).metaSchema(JsonMetaSchema.getV202012()).build();
            SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().pathType(PathType.JSON_POINTER).build();
            URI schemaUri = this.getClass().getResource(this.schemaPath).toURI();
            return factory.getSchema(schemaUri, schemaNode, config);
        }
        catch (IOException | URISyntaxException e) {
            throw new OutputConfigurationException("Failed to load schema: " + this.schemaPath, e);
        }
    }

    public void validate(String yamlContent) {
        try {
            JsonNode configNode = this.yamlMapper.readTree(yamlContent);
            Set errors = this.schema.validate(configNode);
            if (!errors.isEmpty()) {
                StringBuilder errorMessage = new StringBuilder("Output configuration validation failed:\n");
                for (ValidationMessage error : errors) {
                    errorMessage.append("  - ").append(error.getInstanceLocation()).append(": ").append(error.getMessage()).append("\n");
                }
                throw new OutputConfigurationException(errorMessage.toString());
            }
        }
        catch (IOException e) {
            throw new OutputConfigurationException("Failed to parse YAML", e);
        }
    }
}

