/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SuggestionsConfig {
    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_MAX_PER_ERROR = 3;
    private static final boolean DEFAULT_SHOW_EXAMPLES = true;
    private static final boolean DEFAULT_SHOW_AUTO_FIX_HINT = true;
    private final boolean enabled;
    private final int maxPerError;
    private final boolean showExamples;
    private final boolean showAutoFixHint;

    private SuggestionsConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.maxPerError = builder.maxPerError;
        this.showExamples = builder.showExamples;
        this.showAutoFixHint = builder.showAutoFixHint;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxPerError() {
        return this.maxPerError;
    }

    public boolean isShowExamples() {
        return this.showExamples;
    }

    public boolean isShowAutoFixHint() {
        return this.showAutoFixHint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestionsConfig that = (SuggestionsConfig)o;
        return this.enabled == that.enabled && this.maxPerError == that.maxPerError && this.showExamples == that.showExamples && this.showAutoFixHint == that.showAutoFixHint;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.maxPerError, this.showExamples, this.showAutoFixHint);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private boolean enabled = true;
        private int maxPerError = 3;
        private boolean showExamples = true;
        private boolean showAutoFixHint = true;

        private Builder() {
        }

        @JsonProperty(value="enabled")
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @JsonProperty(value="maxPerError")
        public Builder maxPerError(int maxPerError) {
            this.maxPerError = maxPerError;
            return this;
        }

        @JsonProperty(value="showExamples")
        public Builder showExamples(boolean showExamples) {
            this.showExamples = showExamples;
            return this;
        }

        @JsonProperty(value="showAutoFixHint")
        public Builder showAutoFixHint(boolean showAutoFixHint) {
            this.showAutoFixHint = showAutoFixHint;
            return this;
        }

        public SuggestionsConfig build() {
            return new SuggestionsConfig(this);
        }
    }
}

