/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SummaryConfig {
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean DEFAULT_SHOW_STATISTICS = true;
    private static final boolean DEFAULT_SHOW_MOST_COMMON = true;
    private static final boolean DEFAULT_SHOW_FILE_LIST = false;
    private final boolean enabled;
    private final boolean showStatistics;
    private final boolean showMostCommon;
    private final boolean showFileList;

    private SummaryConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.showStatistics = builder.showStatistics;
        this.showMostCommon = builder.showMostCommon;
        this.showFileList = builder.showFileList;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isShowStatistics() {
        return this.showStatistics;
    }

    public boolean isShowMostCommon() {
        return this.showMostCommon;
    }

    public boolean isShowFileList() {
        return this.showFileList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SummaryConfig that = (SummaryConfig)o;
        return this.enabled == that.enabled && this.showStatistics == that.showStatistics && this.showMostCommon == that.showMostCommon && this.showFileList == that.showFileList;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.showStatistics, this.showMostCommon, this.showFileList);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private boolean enabled = true;
        private boolean showStatistics = true;
        private boolean showMostCommon = true;
        private boolean showFileList = false;

        private Builder() {
        }

        @JsonProperty(value="enabled")
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @JsonProperty(value="showStatistics")
        public Builder showStatistics(boolean showStatistics) {
            this.showStatistics = showStatistics;
            return this;
        }

        @JsonProperty(value="showMostCommon")
        public Builder showMostCommon(boolean showMostCommon) {
            this.showMostCommon = showMostCommon;
            return this;
        }

        @JsonProperty(value="showFileList")
        public Builder showFileList(boolean showFileList) {
            this.showFileList = showFileList;
            return this;
        }

        public SummaryConfig build() {
            return new SummaryConfig(this);
        }
    }
}

