/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.rule;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AttributeConfig {
    private final String name;
    private final Integer order;
    private final boolean required;
    private final Integer minLength;
    private final Integer maxLength;
    private final String pattern;
    private final Severity severity;

    private AttributeConfig(Builder builder) {
        this.name = builder.name;
        this.order = builder.order;
        this.required = builder.required;
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.pattern = builder.pattern;
        this.severity = builder.severity;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonProperty(value="order")
    public Integer order() {
        return this.order;
    }

    @JsonProperty(value="required")
    public boolean required() {
        return this.required;
    }

    @JsonProperty(value="minLength")
    public Integer minLength() {
        return this.minLength;
    }

    @JsonProperty(value="maxLength")
    public Integer maxLength() {
        return this.maxLength;
    }

    @JsonProperty(value="pattern")
    public String pattern() {
        return this.pattern;
    }

    @JsonProperty(value="severity")
    public Severity severity() {
        return this.severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeConfig that = (AttributeConfig)o;
        return this.required == that.required && Objects.equals(this.name, that.name) && Objects.equals(this.order, that.order) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.pattern, that.pattern) && this.severity == that.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.order, this.required, this.minLength, this.maxLength, this.pattern, this.severity});
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String name;
        private Integer order;
        private boolean required;
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private Severity severity;

        @JsonProperty(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="order")
        public Builder order(Integer order) {
            this.order = order;
            return this;
        }

        @JsonProperty(value="required")
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @JsonProperty(value="minLength")
        public Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        @JsonProperty(value="maxLength")
        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @JsonProperty(value="pattern")
        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @JsonProperty(value="severity")
        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public AttributeConfig build() {
            Objects.requireNonNull(this.name, "[" + this.getClass().getName() + "] name is required");
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new AttributeConfig(this);
        }
    }
}

