/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.rule;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class LineConfig {
    private final Integer min;
    private final Integer max;
    private final Severity severity;

    private LineConfig(Builder builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.severity = builder.severity;
    }

    @JsonProperty(value="min")
    public Integer min() {
        return this.min;
    }

    @JsonProperty(value="max")
    public Integer max() {
        return this.max;
    }

    @JsonProperty(value="severity")
    public Severity severity() {
        return this.severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineConfig lineRule = (LineConfig)o;
        return Objects.equals(this.min, lineRule.min) && Objects.equals(this.max, lineRule.max) && this.severity == lineRule.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.min, this.max, this.severity});
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Integer min;
        private Integer max;
        private Severity severity;

        @JsonProperty(value="min")
        public Builder min(Integer min) {
            this.min = min;
            return this;
        }

        @JsonProperty(value="max")
        public Builder max(Integer max) {
            this.max = max;
            return this;
        }

        @JsonProperty(value="severity")
        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public LineConfig build() {
            return new LineConfig(this);
        }
    }
}

