/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.rule;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class OccurrenceConfig {
    private final Integer order;
    private final int min;
    private final int max;
    private final Severity severity;

    private OccurrenceConfig(Builder builder) {
        this.order = builder.order;
        this.min = builder.min;
        this.max = builder.max;
        this.severity = builder.severity;
    }

    @JsonProperty(value="order")
    public Integer order() {
        return this.order;
    }

    @JsonProperty(value="min")
    public int min() {
        return this.min;
    }

    @JsonProperty(value="max")
    public int max() {
        return this.max;
    }

    @JsonProperty(value="severity")
    public Severity severity() {
        return this.severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OccurrenceConfig that = (OccurrenceConfig)o;
        return this.min == that.min && this.max == that.max && Objects.equals(this.order, that.order) && this.severity == that.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.order, this.min, this.max, this.severity});
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Integer order;
        private int min = 0;
        private int max = Integer.MAX_VALUE;
        private Severity severity;

        @JsonProperty(value="order")
        public Builder order(Integer order) {
            this.order = order;
            return this;
        }

        @JsonProperty(value="min")
        public Builder min(int min) {
            this.min = min;
            return this;
        }

        @JsonProperty(value="max")
        public Builder max(int max) {
            this.max = max;
            return this;
        }

        @JsonProperty(value="severity")
        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public OccurrenceConfig build() {
            return new OccurrenceConfig(this);
        }
    }
}

