/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.rule;

import com.dataliquid.asciidoc.linter.config.Severity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class OrderConfig {
    private final List<String> fixedOrder;
    private final List<OrderConstraint> before;
    private final List<OrderConstraint> after;
    private final Severity severity;

    private OrderConfig(Builder builder) {
        this.fixedOrder = Collections.unmodifiableList(new ArrayList<String>(builder.fixedOrder));
        this.before = Collections.unmodifiableList(new ArrayList<OrderConstraint>(builder.before));
        this.after = Collections.unmodifiableList(new ArrayList<OrderConstraint>(builder.after));
        this.severity = builder.severity;
    }

    public List<String> fixedOrder() {
        return this.fixedOrder;
    }

    public List<OrderConstraint> before() {
        return this.before;
    }

    public List<OrderConstraint> after() {
        return this.after;
    }

    public Severity severity() {
        return this.severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderConfig that = (OrderConfig)o;
        return Objects.equals(this.fixedOrder, that.fixedOrder) && Objects.equals(this.before, that.before) && Objects.equals(this.after, that.after) && this.severity == that.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fixedOrder, this.before, this.after, this.severity});
    }

    public static class Builder {
        private List<String> fixedOrder = new ArrayList<String>();
        private List<OrderConstraint> before = new ArrayList<OrderConstraint>();
        private List<OrderConstraint> after = new ArrayList<OrderConstraint>();
        private Severity severity = Severity.ERROR;

        public Builder fixedOrder(List<String> fixedOrder) {
            this.fixedOrder = fixedOrder != null ? new ArrayList<String>(fixedOrder) : new ArrayList();
            return this;
        }

        public Builder addFixedOrder(String blockName) {
            this.fixedOrder.add(blockName);
            return this;
        }

        public Builder before(List<OrderConstraint> before) {
            this.before = before != null ? new ArrayList<OrderConstraint>(before) : new ArrayList();
            return this;
        }

        public Builder addBefore(String first, String second, Severity severity) {
            this.before.add(OrderConstraint.of(first, second, severity));
            return this;
        }

        public Builder after(List<OrderConstraint> after) {
            this.after = after != null ? new ArrayList<OrderConstraint>(after) : new ArrayList();
            return this;
        }

        public Builder addAfter(String first, String second, Severity severity) {
            this.after.add(OrderConstraint.of(first, second, severity));
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = Objects.requireNonNull(severity, "[" + this.getClass().getName() + "] severity must not be null");
            return this;
        }

        public OrderConfig build() {
            return new OrderConfig(this);
        }
    }

    public static final class OrderConstraint {
        private final String first;
        private final String second;
        private final Severity severity;

        private OrderConstraint(String first, String second, Severity severity) {
            this.first = Objects.requireNonNull(first, "[" + this.getClass().getName() + "] first must not be null");
            this.second = Objects.requireNonNull(second, "[" + this.getClass().getName() + "] second must not be null");
            this.severity = Objects.requireNonNull(severity, "[" + this.getClass().getName() + "] severity must not be null");
        }

        public String first() {
            return this.first;
        }

        public String second() {
            return this.second;
        }

        public Severity severity() {
            return this.severity;
        }

        public static OrderConstraint of(String first, String second, Severity severity) {
            return new OrderConstraint(first, second, severity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderConstraint that = (OrderConstraint)o;
            return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.first, this.second, this.severity});
        }
    }
}

