/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.rule;

import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.loader.BlockListDeserializer;
import com.dataliquid.asciidoc.linter.config.rule.TitleConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SectionConfig {
    private final String name;
    private final Integer order;
    private final int level;
    private final int min;
    private final int max;
    private final TitleConfig title;
    private final List<Block> allowedBlocks;
    private final List<SectionConfig> subsections;

    private SectionConfig(Builder builder) {
        this.name = builder.name;
        this.order = builder.order;
        this.level = builder.level;
        this.min = builder.min;
        this.max = builder.max;
        this.title = builder.title;
        this.allowedBlocks = Collections.unmodifiableList(new ArrayList<Block>(builder.allowedBlocks));
        this.subsections = Collections.unmodifiableList(new ArrayList<SectionConfig>(builder.subsections));
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonProperty(value="order")
    public Integer order() {
        return this.order;
    }

    @JsonProperty(value="level")
    public int level() {
        return this.level;
    }

    @JsonProperty(value="min")
    public int min() {
        return this.min;
    }

    @JsonProperty(value="max")
    public int max() {
        return this.max;
    }

    @JsonProperty(value="title")
    public TitleConfig title() {
        return this.title;
    }

    @JsonProperty(value="allowedBlocks")
    public List<Block> allowedBlocks() {
        return this.allowedBlocks;
    }

    @JsonProperty(value="subsections")
    public List<SectionConfig> subsections() {
        return this.subsections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SectionConfig that = (SectionConfig)o;
        return this.level == that.level && this.min == that.min && this.max == that.max && Objects.equals(this.name, that.name) && Objects.equals(this.order, that.order) && Objects.equals(this.title, that.title) && Objects.equals(this.allowedBlocks, that.allowedBlocks) && Objects.equals(this.subsections, that.subsections);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.order, this.level, this.min, this.max, this.title, this.allowedBlocks, this.subsections);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String name;
        private Integer order;
        private int level;
        private int min = 0;
        private int max = Integer.MAX_VALUE;
        private TitleConfig title;
        private List<Block> allowedBlocks = new ArrayList<Block>();
        private List<SectionConfig> subsections = new ArrayList<SectionConfig>();

        @JsonProperty(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="order")
        public Builder order(Integer order) {
            this.order = order;
            return this;
        }

        @JsonProperty(value="level")
        public Builder level(int level) {
            this.level = level;
            return this;
        }

        @JsonProperty(value="min")
        public Builder min(int min) {
            this.min = min;
            return this;
        }

        @JsonProperty(value="max")
        public Builder max(int max) {
            this.max = max;
            return this;
        }

        @JsonProperty(value="title")
        public Builder title(TitleConfig title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="allowedBlocks")
        @JsonDeserialize(using=BlockListDeserializer.class)
        public Builder allowedBlocks(List<Block> allowedBlocks) {
            this.allowedBlocks = allowedBlocks != null ? new ArrayList<Block>(allowedBlocks) : new ArrayList();
            return this;
        }

        public Builder addAllowedBlock(Block block) {
            this.allowedBlocks.add(block);
            return this;
        }

        @JsonProperty(value="subsections")
        public Builder subsections(List<SectionConfig> subsections) {
            this.subsections = subsections != null ? new ArrayList<SectionConfig>(subsections) : new ArrayList();
            return this;
        }

        public Builder addSubsection(SectionConfig subsection) {
            this.subsections.add(subsection);
            return this;
        }

        public SectionConfig build() {
            return new SectionConfig(this);
        }
    }
}

