/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.rule;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class TitleConfig {
    private final String pattern;
    private final String exactMatch;
    private final Severity severity;

    private TitleConfig(Builder builder) {
        this.pattern = builder.pattern;
        this.exactMatch = builder.exactMatch;
        this.severity = builder.severity;
    }

    @JsonProperty(value="pattern")
    public String pattern() {
        return this.pattern;
    }

    @JsonProperty(value="exactMatch")
    public String exactMatch() {
        return this.exactMatch;
    }

    @JsonProperty(value="severity")
    public Severity severity() {
        return this.severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TitleConfig that = (TitleConfig)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.exactMatch, that.exactMatch) && this.severity == that.severity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pattern, this.exactMatch, this.severity});
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String pattern;
        private String exactMatch;
        private Severity severity = Severity.ERROR;

        @JsonProperty(value="pattern")
        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @JsonProperty(value="exactMatch")
        public Builder exactMatch(String exactMatch) {
            this.exactMatch = exactMatch;
            return this;
        }

        @JsonProperty(value="severity")
        public Builder severity(Severity severity) {
            this.severity = Objects.requireNonNull(severity, "[" + this.getClass().getName() + "] severity must not be null");
            return this;
        }

        public TitleConfig build() {
            if (this.pattern == null && this.exactMatch == null) {
                throw new IllegalStateException("Either pattern or exactMatch must be specified");
            }
            if (this.pattern != null && this.exactMatch != null) {
                throw new IllegalStateException("Cannot specify both pattern and exactMatch");
            }
            return new TitleConfig(this);
        }
    }
}

