/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.validation;

import com.dataliquid.asciidoc.linter.config.validation.RuleValidationException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;

public class RuleSchemaValidator {
    private static final String SCHEMA_PATH = "/schemas/rules/linter-config-schema.yaml";
    private final JsonSchema schema;
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public RuleSchemaValidator() {
        this.schema = this.loadSchema();
    }

    private JsonSchema loadSchema() {
        try {
            InputStream schemaStream = this.getClass().getResourceAsStream(SCHEMA_PATH);
            if (schemaStream == null) {
                throw new RuleValidationException("Schema not found: /schemas/rules/linter-config-schema.yaml");
            }
            JsonNode schemaNode = this.yamlMapper.readTree(schemaStream);
            String baseClasspathUrl = this.getClass().getResource("/schemas/").toString();
            JsonSchemaFactory factory = JsonSchemaFactory.builder().defaultMetaSchemaIri(JsonMetaSchema.getV202012().getIri()).schemaMappers(schemaMappers -> schemaMappers.mapPrefix("https://dataliquid.com/asciidoc/linter/schemas/", baseClasspathUrl)).metaSchema(JsonMetaSchema.getV202012()).build();
            SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().pathType(PathType.JSON_POINTER).build();
            URI schemaUri = this.getClass().getResource(SCHEMA_PATH).toURI();
            return factory.getSchema(schemaUri, schemaNode, config);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuleValidationException("Failed to load schema", e);
        }
    }

    public void validateUserConfig(Path userConfigFile) throws RuleValidationException {
        if (!Files.exists(userConfigFile, new LinkOption[0])) {
            throw new RuleValidationException("Configuration file not found: " + String.valueOf(userConfigFile));
        }
        try {
            JsonNode configNode = this.yamlMapper.readTree(userConfigFile.toFile());
            this.validateUserConfig(configNode);
        }
        catch (IOException e) {
            throw new RuleValidationException("Failed to read configuration file: " + String.valueOf(userConfigFile), e);
        }
    }

    public void validateUserConfig(JsonNode userConfigNode) throws RuleValidationException {
        Set messages = this.schema.validate(userConfigNode);
        if (!messages.isEmpty()) {
            throw new RuleValidationException(this.formatErrors(messages));
        }
    }

    public void validateUserConfig(InputStream yamlStream) throws RuleValidationException {
        try {
            JsonNode configNode = this.yamlMapper.readTree(yamlStream);
            this.validateUserConfig(configNode);
        }
        catch (IOException e) {
            throw new RuleValidationException("Failed to parse YAML configuration", e);
        }
    }

    public void validateYamlString(String yamlContent) throws RuleValidationException {
        try {
            JsonNode configNode = this.yamlMapper.readTree(yamlContent);
            this.validateUserConfig(configNode);
        }
        catch (IOException e) {
            throw new RuleValidationException("Failed to parse YAML configuration string", e);
        }
    }

    private String formatErrors(Set<ValidationMessage> messages) {
        StringBuilder sb = new StringBuilder("User configuration does not match schema:");
        for (ValidationMessage msg : messages) {
            sb.append("\n\n  Error at ").append(msg.getInstanceLocation()).append(":");
            sb.append("\n    ").append(msg.getMessage());
            if ("enum".equals(msg.getType())) {
                sb.append("\n    Valid values: error, warn, info");
                continue;
            }
            if ("required".equals(msg.getType())) {
                sb.append("\n    This field is required");
                continue;
            }
            if (!"minimum".equals(msg.getType()) && !"maximum".equals(msg.getType())) continue;
            sb.append("\n    Check the allowed range");
        }
        return sb.toString();
    }
}

