/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.validation;

import com.networknt.schema.ValidationMessage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RuleValidationResult {
    private final List<ValidationError> errors;

    private RuleValidationResult(List<ValidationError> errors) {
        this.errors = Collections.unmodifiableList(errors);
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public static RuleValidationResult from(Set<ValidationMessage> messages) {
        List<ValidationError> errors = messages.stream().map(RuleValidationResult::convertMessage).collect(Collectors.toList());
        return new RuleValidationResult(errors);
    }

    private static ValidationError convertMessage(ValidationMessage msg) {
        return new ValidationError(msg.getInstanceLocation().toString(), msg.getMessage(), msg.getType());
    }

    public static class ValidationError {
        private final String path;
        private final String message;
        private final String keyword;

        public ValidationError(String path, String message, String keyword) {
            this.path = path;
            this.message = message;
            this.keyword = keyword;
        }

        public String getPath() {
            return this.path;
        }

        public String getMessage() {
            return this.message;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String format() {
            return String.format("  - %s: %s", this.path, this.message);
        }
    }
}

