/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.documentation;

import com.dataliquid.asciidoc.linter.documentation.HierarchyVisualizer;
import com.dataliquid.asciidoc.linter.documentation.VisualizationStyle;
import com.dataliquid.asciidoc.linter.documentation.visualizers.BreadcrumbVisualizer;
import com.dataliquid.asciidoc.linter.documentation.visualizers.NestedListVisualizer;
import com.dataliquid.asciidoc.linter.documentation.visualizers.TableVisualizer;
import com.dataliquid.asciidoc.linter.documentation.visualizers.TreeVisualizer;
import java.util.HashMap;
import java.util.Map;

public class HierarchyVisualizerFactory {
    private final Map<VisualizationStyle, HierarchyVisualizer> visualizers = new HashMap<VisualizationStyle, HierarchyVisualizer>();

    public HierarchyVisualizerFactory() {
        this.registerVisualizers();
    }

    private void registerVisualizers() {
        this.visualizers.put(VisualizationStyle.TREE, new TreeVisualizer());
        this.visualizers.put(VisualizationStyle.NESTED, new NestedListVisualizer());
        this.visualizers.put(VisualizationStyle.BREADCRUMB, new BreadcrumbVisualizer());
        this.visualizers.put(VisualizationStyle.TABLE, new TableVisualizer());
    }

    public HierarchyVisualizer create(VisualizationStyle style) {
        HierarchyVisualizer visualizer = this.visualizers.get((Object)style);
        if (visualizer == null) {
            throw new IllegalArgumentException("No visualizer available for style: " + String.valueOf((Object)style));
        }
        return visualizer;
    }

    public boolean hasVisualizer(VisualizationStyle style) {
        return this.visualizers.containsKey((Object)style);
    }
}

