/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.documentation;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatternHumanizer {
    private final Map<String, String> knownPatterns = new HashMap<String, String>();

    public PatternHumanizer() {
        this.initializeKnownPatterns();
    }

    private void initializeKnownPatterns() {
        this.knownPatterns.put("^[A-Z].*", "Must start with an uppercase letter");
        this.knownPatterns.put("^[a-z].*", "Must start with a lowercase letter");
        this.knownPatterns.put("^\\d+\\.\\d+\\.\\d+$", "Semantic Versioning Format (e.g. 1.0.0)");
        this.knownPatterns.put("^[\\w._%+-]+@[\\w.-]+\\.[A-Za-z]{2,}$", "Valid email address");
        this.knownPatterns.put("^https?://.*", "Must start with http:// or https://");
        this.knownPatterns.put(".*\\.(png|jpg|jpeg|gif|svg)$", "Image file (PNG, JPG, JPEG, GIF or SVG)");
        this.knownPatterns.put(".*\\.(mp3|ogg|wav|m4a)$", "Audio file (MP3, OGG, WAV or M4A)");
        this.knownPatterns.put("^(Introduction|Einf\u00fchrung)$", "Must be 'Introduction' or 'Einf\u00fchrung'");
        this.knownPatterns.put("^Listing \\d+:.*", "Must start with 'Listing' followed by a number and colon");
        this.knownPatterns.put("^Table \\d+:.*", "Must start with 'Table' followed by a number and colon");
        this.knownPatterns.put("^Figure \\d+:.*", "Must start with 'Figure' followed by a number and colon");
        this.knownPatterns.put("^(java|python|javascript|yaml|json|xml)$", "Allowed languages: java, python, javascript, yaml, json, xml");
    }

    public String humanize(Pattern pattern) {
        if (pattern == null) {
            return "";
        }
        return this.humanize(pattern.pattern());
    }

    public String humanize(String patternString) {
        if (patternString == null || patternString.isEmpty()) {
            return "";
        }
        String known = this.knownPatterns.get(patternString);
        if (known != null) {
            return known;
        }
        String description = this.generateDescription(patternString);
        if (description != null) {
            return description;
        }
        return "Must match pattern: " + patternString;
    }

    private String generateDescription(String pattern) {
        String exact;
        String suffix;
        String prefix;
        if (pattern.matches(".*\\\\\\.(\\w+\\|)*\\w+\\)\\$")) {
            String extensions = pattern.replaceAll(".*\\\\\\.(\\()?", "").replaceAll("\\)\\$", "").replaceAll("\\|", ", ");
            return "File extension must be: " + extensions.toUpperCase();
        }
        if (pattern.startsWith("^") && !pattern.contains("$") && !(prefix = pattern.substring(1).replaceAll("\\\\_", "_")).contains("[") && !prefix.contains("(")) {
            return "Must start with '" + prefix + "'";
        }
        if (pattern.endsWith("$") && !pattern.startsWith("^") && !(suffix = pattern.substring(0, pattern.length() - 1)).contains("[") && !suffix.contains("(")) {
            return "Must end with '" + suffix + "'";
        }
        if (pattern.startsWith("^") && pattern.endsWith("$") && !(exact = pattern.substring(1, pattern.length() - 1)).contains("[") && !exact.contains("(") && !exact.contains("*") && !exact.contains("+")) {
            return "Must be exactly '" + exact + "'";
        }
        if (pattern.equals("^[A-Za-z]+$")) {
            return "Only letters allowed";
        }
        if (pattern.equals("^[0-9]+$")) {
            return "Only numbers allowed";
        }
        if (pattern.equals("^[A-Za-z0-9]+$")) {
            return "Only letters and numbers allowed";
        }
        return null;
    }

    public void registerPattern(String pattern, String description) {
        this.knownPatterns.put(pattern, description);
    }
}

