/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.documentation;

public enum VisualizationStyle {
    TREE("tree", "ASCII-art tree structure"),
    NESTED("nested", "Nested lists with severity indicators"),
    BREADCRUMB("breadcrumb", "Path-style representation"),
    TABLE("table", "Hierarchical table with indentation"),
    PLANTUML("plantuml", "PlantUML diagram"),
    SEVERITY_FLOW("severity-flow", "Severity inheritance visualization");

    private final String name;
    private final String description;

    private VisualizationStyle(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static VisualizationStyle fromName(String name) {
        for (VisualizationStyle style : VisualizationStyle.values()) {
            if (!style.name.equalsIgnoreCase(name)) continue;
            return style;
        }
        throw new IllegalArgumentException("Unknown visualization style: " + name);
    }
}

