/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.documentation.visualizers;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.DocumentConfiguration;
import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.MetadataConfiguration;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.AttributeConfig;
import com.dataliquid.asciidoc.linter.config.rule.SectionConfig;
import com.dataliquid.asciidoc.linter.documentation.HierarchyVisualizer;
import com.dataliquid.asciidoc.linter.documentation.VisualizationStyle;
import java.io.PrintWriter;
import java.util.List;

public class NestedListVisualizer
implements HierarchyVisualizer {
    @Override
    public void visualize(LinterConfiguration config, PrintWriter writer) {
        writer.println("=== icon:file-alt[] Document Level");
        writer.println();
        DocumentConfiguration doc = config.document();
        if (doc.metadata() != null) {
            this.visualizeMetadata(doc.metadata(), writer);
        }
        if (doc.sections() != null && !doc.sections().isEmpty()) {
            this.visualizeSections(doc.sections(), "", writer);
        }
    }

    @Override
    public VisualizationStyle getStyle() {
        return VisualizationStyle.NESTED;
    }

    private void visualizeMetadata(MetadataConfiguration metadata, PrintWriter writer) {
        writer.println("* " + this.getSeverityIcon(Severity.ERROR) + " **metadata** _(Required)_");
        if (metadata.attributes() != null) {
            for (AttributeConfig attr : metadata.attributes()) {
                String icon = this.getSeverityIcon(attr.severity());
                String required = attr.required() ? "Required" : "Optional";
                writer.println("** " + icon + " **" + attr.name() + "** - " + this.getAttributeDescription(attr));
                writer.println("*** " + required);
                if (attr.minLength() != null || attr.maxLength() != null) {
                    writer.print("*** ");
                    if (attr.minLength() != null) {
                        writer.print("Min: " + attr.minLength());
                    }
                    if (attr.minLength() != null && attr.maxLength() != null) {
                        writer.print(", ");
                    }
                    if (attr.maxLength() != null) {
                        writer.print("Max: " + attr.maxLength());
                    }
                    writer.println(" characters");
                }
                if (attr.pattern() == null) continue;
                writer.println("*** Pattern: " + attr.pattern());
            }
        }
        writer.println();
    }

    private void visualizeSections(List<SectionConfig> sections, String indent, PrintWriter writer) {
        writer.println(indent + "* icon:folder[] **sections** _(Required)_");
        for (SectionConfig section : sections) {
            this.visualizeSection(section, indent + "*", writer);
        }
    }

    private void visualizeSection(SectionConfig section, String indent, PrintWriter writer) {
        String required = section.min() > 0 ? this.getSeverityIcon(Severity.ERROR) : this.getSeverityIcon(Severity.INFO);
        writer.println(indent + " " + required + " **" + section.name() + "** - " + this.getSectionDescription(section));
        writer.println(indent + "* Level: " + section.level());
        if (section.order() != null) {
            writer.println(indent + "* Position: " + section.order());
        }
        if (section.allowedBlocks() != null && !section.allowedBlocks().isEmpty()) {
            writer.println(indent + "* icon:cubes[] **allowedBlocks**");
            for (Block block : section.allowedBlocks()) {
                this.visualizeBlock(block, indent + "**", writer);
            }
        }
        if (section.subsections() != null && !section.subsections().isEmpty()) {
            writer.println(indent + "* **subsections**");
            for (SectionConfig subsection : section.subsections()) {
                this.visualizeSection(subsection, indent + "*", writer);
            }
        }
    }

    private void visualizeBlock(Block block, String indent, PrintWriter writer) {
        String blockIcon = this.getBlockIcon(block);
        writer.print(indent + " " + blockIcon + " **" + block.getType().toValue() + "**");
        if (block.getName() != null) {
            writer.print(" (" + block.getName() + ")");
        }
        if (block.getOccurrence() != null) {
            writer.print(" (");
            int min = block.getOccurrence().min();
            int max = block.getOccurrence().max();
            if (min > 0 && max < Integer.MAX_VALUE) {
                writer.print(min + "-" + max + " items");
            } else if (min > 0) {
                writer.print("min. " + min + " items");
            } else if (max < Integer.MAX_VALUE) {
                writer.print("max. " + max + " items");
            }
            writer.print(")");
        }
        writer.println();
        this.visualizeBlockRules(block, indent + "*", writer);
    }

    private void visualizeBlockRules(Block block, String indent, PrintWriter writer) {
        writer.println(indent + " " + this.getSeverityIcon(block.getSeverity()) + " Severity: " + String.valueOf((Object)block.getSeverity()));
    }

    private String getSeverityIcon(Severity severity) {
        return switch (severity) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.ERROR -> "icon:times-circle[role=\"red\"]";
            case Severity.WARN -> "icon:exclamation-triangle[role=\"yellow\"]";
            case Severity.INFO -> "icon:info-circle[role=\"blue\"]";
        };
    }

    private String getBlockIcon(Block block) {
        return switch (block.getType()) {
            case BlockType.PARAGRAPH -> "icon:paragraph[]";
            case BlockType.LISTING -> "icon:code[]";
            case BlockType.TABLE -> "icon:table[]";
            case BlockType.IMAGE -> "icon:image[]";
            case BlockType.VERSE -> "icon:quote-left[]";
            case BlockType.ADMONITION -> "icon:exclamation[]";
            case BlockType.PASS -> "icon:forward[]";
            case BlockType.LITERAL -> "icon:file-code[]";
            default -> "icon:file[]";
        };
    }

    private String getAttributeDescription(AttributeConfig attr) {
        return switch (attr.name()) {
            case "title" -> "Document title";
            case "author" -> "Author";
            case "version" -> "Version number";
            case "email" -> "Contact email";
            default -> attr.name();
        };
    }

    private String getSectionDescription(SectionConfig section) {
        return switch (section.name()) {
            case "introduction" -> "Introduction section";
            case "implementation" -> "Implementation details";
            case "conclusion" -> "Summary";
            default -> section.name();
        };
    }
}

