/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.documentation.visualizers;

import com.dataliquid.asciidoc.linter.config.DocumentConfiguration;
import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.MetadataConfiguration;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.AttributeConfig;
import com.dataliquid.asciidoc.linter.config.rule.SectionConfig;
import com.dataliquid.asciidoc.linter.documentation.HierarchyVisualizer;
import com.dataliquid.asciidoc.linter.documentation.VisualizationStyle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TableVisualizer
implements HierarchyVisualizer {
    private static final String INDENT = "{nbsp}{nbsp}";

    @Override
    public void visualize(LinterConfiguration config, PrintWriter writer) {
        List<TableRow> rows = this.collectTableRows(config.document());
        writer.println("[%header,cols=\"<4,^1,^1,2,3\"]");
        writer.println("|===");
        writer.println("|Rule |Level |Severity |Type |Requirements");
        writer.println();
        for (TableRow row : rows) {
            writer.println("|" + this.getIndentedRule(row.rule, row.level));
            writer.println("|" + row.level);
            writer.println("|" + String.valueOf(row.severity != null ? row.severity : "\u2014"));
            writer.println("|" + row.type);
            writer.println("|" + row.requirements);
            writer.println();
        }
        writer.println("|===");
        writer.println();
        writer.println("_* = Overrides parent severity_");
    }

    @Override
    public VisualizationStyle getStyle() {
        return VisualizationStyle.TABLE;
    }

    private List<TableRow> collectTableRows(DocumentConfiguration doc) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        rows.add(new TableRow("**DOCUMENT**", 0, null, "Root", "Base configuration"));
        if (doc.metadata() != null) {
            this.collectMetadataRows(doc.metadata(), 1, rows);
        }
        if (doc.sections() != null && !doc.sections().isEmpty()) {
            rows.add(new TableRow("\u2514 sections", 1, Severity.ERROR, "Container", "At least 1 section"));
            for (SectionConfig section : doc.sections()) {
                this.collectSectionRows(section, 2, rows);
            }
        }
        return rows;
    }

    private void collectMetadataRows(MetadataConfiguration metadata, int level, List<TableRow> rows) {
        rows.add(new TableRow("\u2514 metadata", level, Severity.ERROR, "Container", "Required"));
        if (metadata.attributes() != null) {
            for (int i = 0; i < metadata.attributes().size(); ++i) {
                AttributeConfig attr = metadata.attributes().get(i);
                boolean isLast = i == metadata.attributes().size() - 1;
                String prefix = isLast ? "\u2514 " : "\u251c ";
                String requirements = this.buildAttributeRequirements(attr);
                rows.add(new TableRow(prefix + attr.name(), level + 1, attr.severity(), "Attribute", requirements));
            }
        }
    }

    private void collectSectionRows(SectionConfig section, int level, List<TableRow> rows) {
        String requirements = "Level " + section.level();
        if (section.order() != null) {
            requirements = requirements + ", Position " + section.order();
        }
        Severity severity = section.min() > 0 ? Severity.ERROR : Severity.INFO;
        rows.add(new TableRow("\u2514 " + section.name(), level, severity, "Section", requirements));
        if (section.allowedBlocks() != null && !section.allowedBlocks().isEmpty()) {
            rows.add(new TableRow("\u251c allowedBlocks", level + 1, null, "Container", "Block definitions"));
            for (int i = 0; i < section.allowedBlocks().size(); ++i) {
                Block block = section.allowedBlocks().get(i);
                boolean isLast = i == section.allowedBlocks().size() - 1;
                this.collectBlockRows(block, level + 2, isLast, rows);
            }
        }
        if (section.subsections() != null && !section.subsections().isEmpty()) {
            rows.add(new TableRow("\u2514 subsections", level + 1, null, "Container", "Subsections"));
            for (SectionConfig subsection : section.subsections()) {
                this.collectSectionRows(subsection, level + 2, rows);
            }
        }
    }

    private void collectBlockRows(Block block, int level, boolean isLast, List<TableRow> rows) {
        String prefix = isLast ? "\u2514 " : "\u251c ";
        String requirements = this.getBlockDescription(block);
        rows.add(new TableRow(prefix + block.getType().toValue(), level, block.getSeverity(), "Block", requirements));
    }

    private String getIndentedRule(String rule, int level) {
        StringBuilder indented = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            indented.append(INDENT);
        }
        indented.append(rule);
        return indented.toString();
    }

    private String buildAttributeRequirements(AttributeConfig attr) {
        ArrayList<Object> reqs = new ArrayList<Object>();
        if (attr.required()) {
            reqs.add("Required");
        } else {
            reqs.add("Optional");
        }
        if (attr.minLength() != null || attr.maxLength() != null) {
            if (attr.minLength() != null && attr.maxLength() != null) {
                reqs.add(attr.minLength() + "-" + attr.maxLength() + " characters");
            } else if (attr.minLength() != null) {
                reqs.add("Min. " + attr.minLength() + " characters");
            } else {
                reqs.add("Max. " + attr.maxLength() + " characters");
            }
        }
        if (attr.pattern() != null) {
            reqs.add("Pattern defined");
        }
        return String.join((CharSequence)", ", reqs);
    }

    private String getBlockDescription(Block block) {
        ArrayList<Object> desc = new ArrayList<Object>();
        if (block.getName() != null) {
            desc.add(block.getName());
        }
        if (block.getOccurrence() != null) {
            int min = block.getOccurrence().min();
            int max = block.getOccurrence().max();
            if (min > 0 && max < Integer.MAX_VALUE) {
                desc.add(min + "-" + max + " times");
            } else if (min > 0) {
                desc.add("Min. " + min + " times");
            } else if (max < Integer.MAX_VALUE) {
                desc.add("Max. " + max + " times");
            }
        }
        return desc.isEmpty() ? "No special requirements" : String.join((CharSequence)", ", desc);
    }

    private static class TableRow {
        final String rule;
        final int level;
        final Severity severity;
        final String type;
        final String requirements;

        TableRow(String rule, int level, Severity severity, String type, String requirements) {
            this.rule = rule;
            this.level = level;
            this.severity = severity;
            this.type = type;
            this.requirements = requirements;
        }
    }
}

