/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.documentation.visualizers;

import com.dataliquid.asciidoc.linter.config.DocumentConfiguration;
import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.MetadataConfiguration;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.AttributeConfig;
import com.dataliquid.asciidoc.linter.config.rule.SectionConfig;
import com.dataliquid.asciidoc.linter.documentation.HierarchyVisualizer;
import com.dataliquid.asciidoc.linter.documentation.VisualizationStyle;
import java.io.PrintWriter;
import java.util.List;

public class TreeVisualizer
implements HierarchyVisualizer {
    private static final String VERTICAL = "\u2502   ";
    private static final String BRANCH = "\u251c\u2500\u2500 ";
    private static final String LAST_BRANCH = "\u2514\u2500\u2500 ";
    private static final String EMPTY = "    ";

    @Override
    public void visualize(LinterConfiguration config, PrintWriter writer) {
        writer.println("[literal]");
        writer.println("....");
        this.visualizeDocument(config.document(), "", writer);
        writer.println("....");
    }

    @Override
    public VisualizationStyle getStyle() {
        return VisualizationStyle.TREE;
    }

    private void visualizeDocument(DocumentConfiguration doc, String prefix, PrintWriter writer) {
        boolean hasSections;
        writer.println(prefix + "document/");
        boolean hasMetadata = doc.metadata() != null;
        boolean bl = hasSections = doc.sections() != null && !doc.sections().isEmpty();
        if (hasMetadata) {
            String childPrefix = prefix + (hasSections ? VERTICAL : EMPTY);
            this.visualizeMetadata(doc.metadata(), prefix + BRANCH, childPrefix, writer);
        }
        if (hasSections) {
            this.visualizeSections(doc.sections(), prefix + LAST_BRANCH, prefix + EMPTY, writer);
        }
    }

    private void visualizeMetadata(MetadataConfiguration metadata, String nodePrefix, String childPrefix, PrintWriter writer) {
        writer.println(nodePrefix + "metadata/");
        if (metadata.attributes() != null && !metadata.attributes().isEmpty()) {
            List<AttributeConfig> attrs = metadata.attributes();
            for (int i = 0; i < attrs.size(); ++i) {
                AttributeConfig attr = attrs.get(i);
                boolean isLast = i == attrs.size() - 1;
                String branch = isLast ? LAST_BRANCH : BRANCH;
                String attrLine = childPrefix + branch + attr.name();
                attrLine = attr.required() ? attrLine + " (required)" : attrLine + " (optional)";
                attrLine = attrLine + " [" + String.valueOf((Object)attr.severity()) + "]";
                writer.println(attrLine);
            }
        }
    }

    private void visualizeSections(List<SectionConfig> sections, String nodePrefix, String childPrefix, PrintWriter writer) {
        writer.println(nodePrefix + "sections/");
        for (int i = 0; i < sections.size(); ++i) {
            SectionConfig section = sections.get(i);
            boolean isLast = i == sections.size() - 1;
            String branch = isLast ? LAST_BRANCH : BRANCH;
            String nextChildPrefix = childPrefix + (isLast ? EMPTY : VERTICAL);
            this.visualizeSection(section, childPrefix + branch, nextChildPrefix, writer);
        }
    }

    private void visualizeSection(SectionConfig section, String nodePrefix, String childPrefix, PrintWriter writer) {
        boolean hasSubsections;
        String sectionLine = nodePrefix + section.name() + "/";
        sectionLine = sectionLine + " [Level " + section.level();
        if (section.order() != null) {
            sectionLine = sectionLine + ", Order " + section.order();
        }
        sectionLine = sectionLine + "]";
        writer.println(sectionLine);
        boolean hasBlocks = section.allowedBlocks() != null && !section.allowedBlocks().isEmpty();
        boolean bl = hasSubsections = section.subsections() != null && !section.subsections().isEmpty();
        if (hasBlocks) {
            String blocksPrefix = hasSubsections ? BRANCH : LAST_BRANCH;
            String nextChildPrefix = childPrefix + (hasSubsections ? VERTICAL : EMPTY);
            this.visualizeBlocks(section.allowedBlocks(), childPrefix + blocksPrefix, nextChildPrefix, writer);
        }
        if (hasSubsections) {
            this.visualizeSections(section.subsections(), childPrefix + LAST_BRANCH, childPrefix + EMPTY, writer);
        }
    }

    private void visualizeBlocks(List<Block> blocks, String nodePrefix, String childPrefix, PrintWriter writer) {
        writer.println(nodePrefix + "allowedBlocks/");
        for (int i = 0; i < blocks.size(); ++i) {
            Block block = blocks.get(i);
            boolean isLast = i == blocks.size() - 1;
            String branch = isLast ? LAST_BRANCH : BRANCH;
            String nextChildPrefix = childPrefix + (isLast ? EMPTY : VERTICAL);
            this.visualizeBlock(block, childPrefix + branch, nextChildPrefix, writer);
        }
    }

    private void visualizeBlock(Block block, String nodePrefix, String childPrefix, PrintWriter writer) {
        String blockLine = nodePrefix + block.getType().toValue() + "/";
        if (block.getName() != null) {
            blockLine = blockLine + " (" + block.getName() + ")";
        }
        blockLine = blockLine + " [" + String.valueOf((Object)block.getSeverity()) + "]";
        writer.println(blockLine);
        this.visualizeBlockDetails(block, childPrefix, writer);
    }

    private void visualizeBlockDetails(Block block, String prefix, PrintWriter writer) {
        if (block.getOccurrence() != null) {
            String occurrenceLine = prefix + "\u2514\u2500\u2500 occurrence: ";
            Integer min = block.getOccurrence().min();
            Integer max = block.getOccurrence().max();
            if (min != null) {
                occurrenceLine = occurrenceLine + "min " + min;
            }
            if (max != null) {
                if (min != null) {
                    occurrenceLine = occurrenceLine + ", ";
                }
                occurrenceLine = occurrenceLine + "max " + max;
            }
            if (block.getOccurrence().severity() != null) {
                occurrenceLine = occurrenceLine + " [" + String.valueOf((Object)block.getOccurrence().severity()) + "]";
            }
            writer.println(occurrenceLine);
        }
    }
}

