/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report;

import com.dataliquid.asciidoc.linter.config.output.OutputConfiguration;
import com.dataliquid.asciidoc.linter.config.output.OutputFormat;
import com.dataliquid.asciidoc.linter.report.ReportFormatter;
import com.dataliquid.asciidoc.linter.report.console.GroupingEngine;
import com.dataliquid.asciidoc.linter.report.console.MessageGroup;
import com.dataliquid.asciidoc.linter.report.console.MessageGroups;
import com.dataliquid.asciidoc.linter.report.console.MessageRenderer;
import com.dataliquid.asciidoc.linter.report.console.SummaryRenderer;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConsoleFormatter
implements ReportFormatter {
    private final OutputConfiguration config;
    private final MessageRenderer messageRenderer;
    private final GroupingEngine groupingEngine;
    private final SummaryRenderer summaryRenderer;

    public ConsoleFormatter() {
        this(OutputConfiguration.defaultConfig());
    }

    public ConsoleFormatter(OutputConfiguration config) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        this.messageRenderer = new MessageRenderer(config);
        this.groupingEngine = new GroupingEngine(config.getErrorGrouping());
        this.summaryRenderer = new SummaryRenderer(config.getSummary(), config.getDisplay());
    }

    @Override
    public void format(ValidationResult result, PrintWriter writer) {
        if (this.config.getDisplay().isShowHeader()) {
            this.renderHeader(writer);
        }
        if (!result.getMessages().isEmpty()) {
            this.renderMessages(result, writer);
        } else {
            this.renderNoIssuesFound(writer);
        }
        if (this.config.getSummary().isEnabled()) {
            this.summaryRenderer.render(result, writer);
        }
    }

    private void renderHeader(PrintWriter writer) {
        if (this.config.getFormat() != OutputFormat.COMPACT) {
            writer.println("Validation Report");
            writer.println("=================");
            writer.println();
        }
    }

    private void renderMessages(ValidationResult result, PrintWriter writer) {
        List<ValidationMessage> messages = result.getMessages();
        if (this.config.getErrorGrouping().isEnabled() && this.config.getFormat() != OutputFormat.COMPACT) {
            MessageGroups groups = this.groupingEngine.group(messages);
            if (!groups.getUngroupedMessages().isEmpty()) {
                this.renderUngroupedMessages(groups.getUngroupedMessages(), writer);
            }
            for (MessageGroup group : groups.getGroups()) {
                this.renderGroupedMessages(group, writer);
                writer.println();
            }
        } else if (this.config.getFormat() == OutputFormat.COMPACT) {
            this.renderCompactMessages(messages, writer);
        } else {
            Map<String, List<ValidationMessage>> byFile = this.groupByFile(messages);
            for (Map.Entry<String, List<ValidationMessage>> entry : byFile.entrySet()) {
                this.renderFileMessages(entry.getKey(), entry.getValue(), writer);
            }
        }
    }

    private void renderUngroupedMessages(List<ValidationMessage> messages, PrintWriter writer) {
        Map<String, List<ValidationMessage>> byFile = this.groupByFile(messages);
        for (Map.Entry<String, List<ValidationMessage>> entry : byFile.entrySet()) {
            this.renderFileMessages(entry.getKey(), entry.getValue(), writer);
        }
    }

    private Map<String, List<ValidationMessage>> groupByFile(List<ValidationMessage> messages) {
        return messages.stream().sorted(Comparator.comparing(msg -> msg.getLocation().getFilename()).thenComparing(msg -> msg.getLocation().getStartLine()).thenComparing(msg -> msg.getLocation().getStartColumn())).collect(Collectors.groupingBy(msg -> msg.getLocation().getFilename(), Collectors.toList()));
    }

    private void renderFileMessages(String filename, List<ValidationMessage> messages, PrintWriter writer) {
        if (this.config.getFormat() != OutputFormat.COMPACT) {
            writer.println(filename + ":");
            writer.println();
        }
        for (ValidationMessage message : messages) {
            this.messageRenderer.render(message, writer);
            if (this.config.getFormat() != OutputFormat.ENHANCED) continue;
            writer.println();
        }
        if (this.config.getFormat() != OutputFormat.COMPACT) {
            writer.println();
        }
    }

    private void renderCompactMessages(List<ValidationMessage> messages, PrintWriter writer) {
        for (ValidationMessage message : messages) {
            this.messageRenderer.render(message, writer);
        }
    }

    private void renderGroupedMessages(MessageGroup group, PrintWriter writer) {
        writer.printf("Found %d similar errors: %s%n%n", group.getMessages().size(), group.getCommonDescription());
        for (ValidationMessage msg : group.getMessages()) {
            writer.printf("  %s", msg.getLocation().formatLocation());
            if (msg.getActualValue().isPresent()) {
                writer.printf("   %s", msg.getActualValue().get());
            }
            writer.println();
        }
        if (!group.getMessages().isEmpty() && group.getMessages().get(0).hasSuggestions() && this.config.getSuggestions().isEnabled()) {
            writer.println();
            writer.println("\ud83d\udca1 Common fix: " + group.getMessages().get(0).getSuggestions().get(0).getDescription());
            if (group.getMessages().get(0).hasAutoFixableSuggestions()) {
                writer.println("\ud83d\udd27 Auto-fixable: Use --fix to apply suggested changes");
            }
        }
    }

    private void renderNoIssuesFound(PrintWriter writer) {
        if (this.config.getFormat() != OutputFormat.COMPACT) {
            writer.println("No validation issues found.");
        }
    }

    @Override
    public String getName() {
        return "console";
    }
}

