/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report;

import com.dataliquid.asciidoc.linter.report.ReportFormatter;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonFormatter
implements ReportFormatter {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC);
    private final String name;
    private final ObjectMapper objectMapper;

    public JsonFormatter(String name, boolean prettyPrint) {
        this.name = name;
        this.objectMapper = new ObjectMapper();
        if (prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        } else {
            this.objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public static JsonFormatter pretty() {
        return new JsonFormatter("json", true);
    }

    public static JsonFormatter compact() {
        return new JsonFormatter("json-compact", false);
    }

    @Override
    public void format(ValidationResult result, PrintWriter writer) {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        root.put("timestamp", ISO_FORMATTER.format(Instant.now()));
        root.put("duration", this.formatDuration(result.getValidationTimeMillis()));
        LinkedHashMap<String, Integer> summary = new LinkedHashMap<String, Integer>();
        summary.put("totalMessages", result.getMessages().size());
        summary.put("errors", result.getErrorCount());
        summary.put("warnings", result.getWarningCount());
        summary.put("infos", result.getInfoCount());
        root.put("summary", summary);
        List messages = result.getMessages().stream().map(this::formatMessage).collect(Collectors.toList());
        root.put("messages", messages);
        try {
            this.objectMapper.writeValue((Writer)writer, root);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JSON output", e);
        }
    }

    private Map<String, Object> formatMessage(ValidationMessage msg) {
        LinkedHashMap<String, Object> msgMap = new LinkedHashMap<String, Object>();
        msgMap.put("file", msg.getLocation().getFilename());
        msgMap.put("line", msg.getLocation().getStartLine());
        if (msg.getLocation().getStartColumn() > 1) {
            msgMap.put("column", msg.getLocation().getStartColumn());
        }
        msgMap.put("severity", msg.getSeverity().toString());
        msgMap.put("message", msg.getMessage());
        if (msg.getRuleId() != null) {
            msgMap.put("ruleId", msg.getRuleId());
        }
        msg.getActualValue().ifPresent(value -> msgMap.put("actualValue", value));
        msg.getExpectedValue().ifPresent(value -> msgMap.put("expectedValue", value));
        return msgMap;
    }

    private String formatDuration(long millis) {
        if (millis < 1000L) {
            return millis + "ms";
        }
        return String.format("%.3fs", (double)millis / 1000.0);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

