/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report;

import com.dataliquid.asciidoc.linter.config.output.OutputConfiguration;
import com.dataliquid.asciidoc.linter.report.ConsoleFormatter;
import com.dataliquid.asciidoc.linter.report.JsonFormatter;
import com.dataliquid.asciidoc.linter.report.ReportFormatter;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReportWriter {
    private final Map<String, ReportFormatter> formatters = new HashMap<String, ReportFormatter>();

    public ReportWriter() {
        this.registerDefaultFormatters();
    }

    private void registerDefaultFormatters() {
        this.registerFormatter(JsonFormatter.pretty());
        this.registerFormatter(JsonFormatter.compact());
    }

    public void registerFormatter(ReportFormatter formatter) {
        Objects.requireNonNull(formatter, "[" + this.getClass().getName() + "] formatter must not be null");
        this.formatters.put(formatter.getName(), formatter);
    }

    public void write(ValidationResult result, String format, String outputPath) throws IOException {
        this.write(result, format, outputPath, null);
    }

    public void write(ValidationResult result, String format, String outputPath, OutputConfiguration outputConfig) throws IOException {
        Objects.requireNonNull(result, "[" + this.getClass().getName() + "] result must not be null");
        ReportFormatter formatter = this.getFormatter(format, outputConfig);
        if (outputPath == null) {
            this.writeToConsole(result, formatter);
        } else {
            this.writeToFile(result, formatter, outputPath);
        }
    }

    public void write(ValidationResult result, String format, Path outputPath) throws IOException {
        this.write(result, format, outputPath != null ? outputPath.toString() : null);
    }

    public void write(ValidationResult result, String format, PrintWriter writer) {
        this.write(result, format, writer, null);
    }

    public void write(ValidationResult result, String format, PrintWriter writer, OutputConfiguration outputConfig) {
        Objects.requireNonNull(result, "[" + this.getClass().getName() + "] result must not be null");
        Objects.requireNonNull(writer, "[" + this.getClass().getName() + "] writer must not be null");
        ReportFormatter formatter = this.getFormatter(format, outputConfig);
        formatter.format(result, writer);
        writer.flush();
    }

    public void writeToConsole(ValidationResult result, String format) {
        this.writeToConsole(result, format, null);
    }

    public void writeToConsole(ValidationResult result, String format, OutputConfiguration outputConfig) {
        Objects.requireNonNull(result, "[" + this.getClass().getName() + "] result must not be null");
        ReportFormatter formatter = this.getFormatter(format, outputConfig);
        this.writeToConsole(result, formatter);
    }

    private void writeToConsole(ValidationResult result, ReportFormatter formatter) {
        try (PrintWriter writer = new PrintWriter(System.out);){
            formatter.format(result, writer);
            writer.flush();
        }
    }

    private void writeToFile(ValidationResult result, ReportFormatter formatter, String outputPath) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(outputPath, StandardCharsets.UTF_8));){
            formatter.format(result, writer);
        }
    }

    private ReportFormatter getFormatter(String format, OutputConfiguration outputConfig) {
        String formatName;
        String string = formatName = format != null ? format.toLowerCase() : "console";
        if ("console".equals(formatName)) {
            if (outputConfig != null) {
                return new ConsoleFormatter(outputConfig);
            }
            return new ConsoleFormatter();
        }
        ReportFormatter formatter = this.formatters.get(formatName);
        if (formatter == null) {
            throw new IllegalArgumentException("Unsupported format: " + format + ". Available formats: console, " + String.valueOf(this.getAvailableFormats()));
        }
        return formatter;
    }

    public Set<String> getAvailableFormats() {
        return this.formatters.keySet();
    }

    public static int calculateExitCode(ValidationResult result) {
        return result.hasErrors() ? 1 : 0;
    }
}

