/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.Severity;

public class ColorScheme {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_GRAY = "\u001b[90m";
    private static final String ANSI_BOLD = "\u001b[1m";
    private static final String ANSI_DIM = "\u001b[2m";
    private final boolean useColors;

    public ColorScheme(boolean useColors) {
        this.useColors = useColors;
    }

    public String colorize(String text, Severity severity) {
        if (!this.useColors) {
            return text;
        }
        return switch (severity) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.ERROR -> ANSI_RED + text + ANSI_RESET;
            case Severity.WARN -> ANSI_YELLOW + text + ANSI_RESET;
            case Severity.INFO -> ANSI_BLUE + text + ANSI_RESET;
        };
    }

    public String error(String text) {
        return this.useColors ? ANSI_RED + text + ANSI_RESET : text;
    }

    public String warning(String text) {
        return this.useColors ? ANSI_YELLOW + text + ANSI_RESET : text;
    }

    public String info(String text) {
        return this.useColors ? ANSI_BLUE + text + ANSI_RESET : text;
    }

    public String success(String text) {
        return this.useColors ? ANSI_GREEN + text + ANSI_RESET : text;
    }

    public String code(String text) {
        return this.useColors ? ANSI_CYAN + text + ANSI_RESET : text;
    }

    public String contextLine(String text) {
        return this.useColors ? ANSI_DIM + text + ANSI_RESET : text;
    }

    public String contextLineNumber(String lineNum) {
        return this.useColors ? ANSI_GRAY + lineNum + ANSI_RESET : lineNum;
    }

    public String errorLineNumber(String lineNum) {
        return this.useColors ? "\u001b[31m\u001b[1m" + lineNum + ANSI_RESET : lineNum;
    }

    public String errorMarker(String marker) {
        return this.useColors ? ANSI_RED + marker + ANSI_RESET : marker;
    }

    public String suggestion(String text) {
        return this.useColors ? ANSI_GREEN + text + ANSI_RESET : text;
    }

    public String suggestionIcon(String icon) {
        return this.useColors ? ANSI_YELLOW + icon + ANSI_RESET : icon;
    }

    public String autoFixHint(String text) {
        return this.useColors ? ANSI_GREEN + text + ANSI_RESET : text;
    }

    public String separator(String separator) {
        return this.useColors ? ANSI_GRAY + separator + ANSI_RESET : separator;
    }

    public String header(String text) {
        return this.useColors ? ANSI_BOLD + text + ANSI_RESET : text;
    }

    public String errorBar(String bar) {
        return this.useColors ? ANSI_RED + bar + ANSI_RESET : bar;
    }

    public String warningBar(String bar) {
        return this.useColors ? ANSI_YELLOW + bar + ANSI_RESET : bar;
    }

    public String infoBar(String bar) {
        return this.useColors ? ANSI_BLUE + bar + ANSI_RESET : bar;
    }
}

