/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.output.DisplayConfig;
import com.dataliquid.asciidoc.linter.report.console.FileContentCache;
import com.dataliquid.asciidoc.linter.report.console.SourceContext;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import java.util.List;
import java.util.Objects;

public class ContextRenderer {
    private final DisplayConfig config;
    private final FileContentCache fileCache;

    public ContextRenderer(DisplayConfig config) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        this.fileCache = new FileContentCache();
    }

    public SourceContext getContext(ValidationMessage message) {
        SourceLocation loc = message.getLocation();
        if (!message.getContextLines().isEmpty()) {
            return new SourceContext(message.getContextLines(), Math.max(1, loc.getStartLine() - this.config.getContextLines()), loc);
        }
        List<String> fileLines = this.fileCache.getFileLines(loc.getFilename());
        if (fileLines.isEmpty()) {
            return new SourceContext(List.of(), loc.getStartLine(), loc);
        }
        int startLine = Math.max(1, loc.getStartLine() - this.config.getContextLines());
        int endLine = Math.min(fileLines.size(), loc.getEndLine() + this.config.getContextLines());
        int fromIndex = Math.max(0, Math.min(startLine - 1, fileLines.size()));
        int toIndex = Math.max(fromIndex, Math.min(endLine, fileLines.size()));
        List<String> contextLines = fileLines.subList(fromIndex, toIndex);
        return new SourceContext(contextLines, startLine, loc);
    }

    public void clearCache() {
        this.fileCache.clear();
    }
}

