/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileContentCache {
    private final Map<String, List<String>> cache = new HashMap<String, List<String>>();

    public List<String> getFileLines(String filename) {
        return this.cache.computeIfAbsent(filename, this::readFileLines);
    }

    private List<String> readFileLines(String filename) {
        try {
            Path path = Paths.get(filename, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
                return Files.readAllLines(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return List.of();
    }

    public void clear() {
        this.cache.clear();
    }
}

