/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.output.ErrorGroupingConfig;
import com.dataliquid.asciidoc.linter.report.console.MessageGroup;
import com.dataliquid.asciidoc.linter.report.console.MessageGroups;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupingEngine {
    private final ErrorGroupingConfig config;

    public GroupingEngine(ErrorGroupingConfig config) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
    }

    public MessageGroups group(List<ValidationMessage> messages) {
        if (!this.config.isEnabled()) {
            return new MessageGroups(List.of(), messages);
        }
        HashMap<String, List> byRuleId = new HashMap<String, List>();
        for (ValidationMessage msg : messages) {
            byRuleId.computeIfAbsent(msg.getRuleId(), k -> new ArrayList()).add(msg);
        }
        ArrayList<MessageGroup> groups = new ArrayList<MessageGroup>();
        ArrayList<ValidationMessage> ungrouped = new ArrayList<ValidationMessage>();
        for (Map.Entry entry : byRuleId.entrySet()) {
            List ruleMessages = (List)entry.getValue();
            if (ruleMessages.size() >= this.config.getThreshold()) {
                groups.add(new MessageGroup((String)entry.getKey(), ruleMessages));
                continue;
            }
            ungrouped.addAll(ruleMessages);
        }
        groups.sort((a, b) -> Integer.compare(b.size(), a.size()));
        return new MessageGroups(groups, ungrouped);
    }
}

