/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.output.DisplayConfig;
import com.dataliquid.asciidoc.linter.config.output.HighlightStyle;
import com.dataliquid.asciidoc.linter.report.console.ColorScheme;
import com.dataliquid.asciidoc.linter.report.console.SourceContext;
import com.dataliquid.asciidoc.linter.validator.ErrorType;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import java.io.PrintWriter;
import java.util.Objects;

public class HighlightRenderer {
    private static final String PLACEHOLDER_START = "\u00ab";
    private static final String PLACEHOLDER_END = "\u00bb";
    private final DisplayConfig config;
    private final ColorScheme colorScheme;

    public HighlightRenderer(DisplayConfig config) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        this.colorScheme = new ColorScheme(config.isUseColors());
    }

    public void renderWithHighlight(SourceContext context, ValidationMessage message, PrintWriter writer) {
        for (SourceContext.ContextLine line : context.getLines()) {
            this.renderLine(line, message, writer);
        }
    }

    private void renderLine(SourceContext.ContextLine line, ValidationMessage message, PrintWriter writer) {
        Object linePrefix = "";
        if (this.config.isShowLineNumbers()) {
            String lineNum = String.format("%4d", line.getNumber());
            linePrefix = line.isErrorLine() ? this.colorScheme.errorLineNumber(lineNum) + " | " : this.colorScheme.contextLineNumber(lineNum) + " | ";
        }
        if (line.isErrorLine()) {
            String highlightedContent = this.highlightErrorInLine(line.getContent(), message, line.getNumber());
            writer.println((String)linePrefix + highlightedContent);
            if (this.config.getHighlightStyle() == HighlightStyle.UNDERLINE && this.shouldShowUnderline(message)) {
                this.renderUnderline(line, message, writer);
            }
        } else {
            writer.println((String)linePrefix + this.colorScheme.contextLine(line.getContent()));
        }
    }

    private String highlightErrorInLine(String line, ValidationMessage message, int lineNum) {
        if (message.getErrorType() == ErrorType.MISSING_VALUE && message.getMissingValueHint() != null) {
            return this.insertPlaceholder(line, message);
        }
        return line;
    }

    private String insertPlaceholder(String line, ValidationMessage message) {
        int col = message.getLocation().getStartColumn();
        if (col <= 0 || col > line.length()) {
            return line + this.colorScheme.error(PLACEHOLDER_START + message.getMissingValueHint() + PLACEHOLDER_END);
        }
        String before = line.substring(0, col - 1);
        String after = col < line.length() ? line.substring(col - 1) : "";
        String placeholder = this.colorScheme.error(PLACEHOLDER_START + message.getMissingValueHint() + PLACEHOLDER_END);
        return before + placeholder + after;
    }

    private boolean shouldShowUnderline(ValidationMessage message) {
        if (message.getErrorType() == ErrorType.MISSING_VALUE) {
            return false;
        }
        return message.getErrorType() == ErrorType.INVALID_PATTERN || message.getErrorType() == ErrorType.OUT_OF_RANGE || message.getErrorType() == ErrorType.INVALID_ENUM;
    }

    private void renderUnderline(SourceContext.ContextLine line, ValidationMessage message, PrintWriter writer) {
        int startCol = message.getLocation().getStartColumn();
        int endCol = message.getLocation().getEndColumn();
        if (startCol <= 0) {
            return;
        }
        if (endCol <= 0 || endCol < startCol) {
            endCol = Math.min(line.getContent().length(), startCol + 20);
        }
        StringBuilder underline = new StringBuilder();
        if (this.config.isShowLineNumbers()) {
            underline.append("     ");
            underline.append("   ");
        }
        underline.append(" ".repeat(Math.max(0, startCol - 1)));
        int length = Math.min(endCol - startCol + 1, this.config.getMaxLineWidth());
        underline.append(this.colorScheme.errorMarker("~".repeat(length)));
        writer.println(underline);
    }
}

