/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class MessageGroup {
    private final String ruleId;
    private final List<ValidationMessage> messages;
    private final String commonDescription;

    public MessageGroup(String ruleId, List<ValidationMessage> messages) {
        this.ruleId = Objects.requireNonNull(ruleId, "[" + this.getClass().getName() + "] ruleId must not be null");
        this.messages = new ArrayList<ValidationMessage>((Collection)Objects.requireNonNull(messages, "[" + this.getClass().getName() + "] messages must not be null"));
        this.commonDescription = messages.isEmpty() ? "Unknown error" : this.extractCommonDescription(messages.get(0));
    }

    private String extractCommonDescription(ValidationMessage firstMessage) {
        String msg = firstMessage.getMessage();
        int colonIndex = msg.indexOf(58);
        if (colonIndex > 0) {
            return msg.substring(0, colonIndex).trim();
        }
        if (msg.contains("must")) {
            int mustIndex = msg.indexOf("must");
            return msg.substring(mustIndex).trim();
        }
        return msg;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public List<ValidationMessage> getMessages() {
        return new ArrayList<ValidationMessage>(this.messages);
    }

    public String getCommonDescription() {
        return this.commonDescription;
    }

    public int size() {
        return this.messages.size();
    }
}

