/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.report.console.MessageGroup;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class MessageGroups {
    private final List<MessageGroup> groups;
    private final List<ValidationMessage> ungroupedMessages;

    public MessageGroups(List<MessageGroup> groups, List<ValidationMessage> ungroupedMessages) {
        this.groups = new ArrayList<MessageGroup>((Collection)Objects.requireNonNull(groups, "[" + this.getClass().getName() + "] groups must not be null"));
        this.ungroupedMessages = new ArrayList<ValidationMessage>((Collection)Objects.requireNonNull(ungroupedMessages, "[" + this.getClass().getName() + "] ungroupedMessages must not be null"));
    }

    public List<MessageGroup> getGroups() {
        return new ArrayList<MessageGroup>(this.groups);
    }

    public List<ValidationMessage> getUngroupedMessages() {
        return new ArrayList<ValidationMessage>(this.ungroupedMessages);
    }

    public boolean hasGroups() {
        return !this.groups.isEmpty();
    }

    public int getTotalMessages() {
        int total = this.ungroupedMessages.size();
        for (MessageGroup group : this.groups) {
            total += group.size();
        }
        return total;
    }
}

