/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.output.OutputConfiguration;
import com.dataliquid.asciidoc.linter.report.console.ColorScheme;
import com.dataliquid.asciidoc.linter.report.console.ContextRenderer;
import com.dataliquid.asciidoc.linter.report.console.HighlightRenderer;
import com.dataliquid.asciidoc.linter.report.console.SourceContext;
import com.dataliquid.asciidoc.linter.report.console.SuggestionRenderer;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

public class MessageRenderer {
    private final OutputConfiguration config;
    private final ContextRenderer contextRenderer;
    private final HighlightRenderer highlightRenderer;
    private final SuggestionRenderer suggestionRenderer;
    private final ColorScheme colorScheme;

    public MessageRenderer(OutputConfiguration config) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        this.contextRenderer = new ContextRenderer(config.getDisplay());
        this.highlightRenderer = new HighlightRenderer(config.getDisplay());
        this.suggestionRenderer = new SuggestionRenderer(config.getSuggestions(), config.getDisplay());
        this.colorScheme = new ColorScheme(config.getDisplay().isUseColors());
    }

    public void render(ValidationMessage message, PrintWriter writer) {
        switch (this.config.getFormat()) {
            case ENHANCED: {
                this.renderEnhanced(message, writer);
                break;
            }
            case SIMPLE: {
                this.renderSimple(message, writer);
                break;
            }
            case COMPACT: {
                this.renderCompact(message, writer);
            }
        }
    }

    private void renderEnhanced(ValidationMessage message, PrintWriter writer) {
        String severityLabel = this.formatSeverity(message);
        String header = severityLabel + ": " + message.getMessage() + " [" + message.getRuleId() + "]";
        writer.println(this.colorScheme.colorize(header, message.getSeverity()));
        writer.println("  File: " + message.getLocation().formatLocation());
        if (message.getCause().isPresent()) {
            writer.println();
            this.renderStackTrace(message.getCause().get(), writer);
        }
        if (this.config.getDisplay().getContextLines() > 0) {
            writer.println();
            SourceContext context = this.contextRenderer.getContext(message);
            this.highlightRenderer.renderWithHighlight(context, message, writer);
        }
        if (this.config.getSuggestions().isEnabled() && message.hasSuggestions()) {
            writer.println();
            this.suggestionRenderer.render(message.getSuggestions(), writer);
        }
    }

    private void renderSimple(ValidationMessage message, PrintWriter writer) {
        String severityLabel = this.formatSeverity(message);
        Object location = String.format("  Line %d", message.getLocation().getStartLine());
        if (message.getLocation().getStartColumn() > 0) {
            location = (String)location + String.format(", Column %d", message.getLocation().getStartColumn());
        }
        writer.println((String)location + ": " + severityLabel + " " + message.getMessage());
        if (this.config.getDisplay().isShowLineNumbers()) {
            writer.println("    Rule: " + message.getRuleId());
        }
        if (message.getActualValue().isPresent() || message.getExpectedValue().isPresent()) {
            message.getActualValue().ifPresent(value -> writer.println("    Actual: " + value));
            message.getExpectedValue().ifPresent(value -> writer.println("    Expected: " + value));
        }
        if (message.getCause().isPresent()) {
            writer.println();
            this.renderStackTrace(message.getCause().get(), writer);
        }
    }

    private void renderCompact(ValidationMessage message, PrintWriter writer) {
        String fixedValue;
        StringBuilder compact = new StringBuilder();
        compact.append(message.getLocation().formatLocation()).append(": ").append((Object)message.getSeverity()).append(": ").append(message.getMessage()).append(" [").append(message.getRuleId()).append("]");
        if (message.hasSuggestions() && !message.getSuggestions().isEmpty() && (fixedValue = message.getSuggestions().get(0).getFixedValue()) != null && !fixedValue.isEmpty()) {
            compact.append(" \u2192 ").append(fixedValue);
        }
        writer.println(compact);
    }

    private String formatSeverity(ValidationMessage message) {
        return switch (message.getSeverity()) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.ERROR -> this.colorScheme.error("[ERROR]");
            case Severity.WARN -> this.colorScheme.warning("[WARN]");
            case Severity.INFO -> this.colorScheme.info("[INFO]");
        };
    }

    private void renderStackTrace(Throwable throwable, PrintWriter writer) {
        String[] lines;
        writer.println("  Stack Trace:");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        for (String line : lines = sw.toString().split("\n")) {
            writer.println("    " + line);
        }
    }
}

