/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SourceContext {
    private final List<ContextLine> lines;
    private final SourceLocation errorLocation;

    public SourceContext(List<String> fileLines, int startLineNumber, SourceLocation errorLocation) {
        this.errorLocation = Objects.requireNonNull(errorLocation, "[" + this.getClass().getName() + "] errorLocation must not be null");
        this.lines = new ArrayList<ContextLine>();
        int lineNum = startLineNumber;
        for (String content : fileLines) {
            boolean isErrorLine = lineNum >= errorLocation.getStartLine() && lineNum <= errorLocation.getEndLine();
            this.lines.add(new ContextLine(lineNum, content, isErrorLine));
            ++lineNum;
        }
    }

    public List<ContextLine> getLines() {
        return new ArrayList<ContextLine>(this.lines);
    }

    public SourceLocation getErrorLocation() {
        return this.errorLocation;
    }

    public static final class ContextLine {
        private final int number;
        private final String content;
        private final boolean errorLine;

        public ContextLine(int number, String content, boolean errorLine) {
            this.number = number;
            this.content = Objects.requireNonNull(content, "[" + this.getClass().getName() + "] content must not be null");
            this.errorLine = errorLine;
        }

        public int getNumber() {
            return this.number;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isErrorLine() {
            return this.errorLine;
        }
    }
}

