/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.output.DisplayConfig;
import com.dataliquid.asciidoc.linter.config.output.SuggestionsConfig;
import com.dataliquid.asciidoc.linter.report.console.ColorScheme;
import com.dataliquid.asciidoc.linter.validator.Suggestion;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;

public class SuggestionRenderer {
    private final SuggestionsConfig config;
    private final ColorScheme colorScheme;

    public SuggestionRenderer(SuggestionsConfig config, DisplayConfig displayConfig) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        this.colorScheme = new ColorScheme(displayConfig.isUseColors());
    }

    public void render(List<Suggestion> suggestions, PrintWriter writer) {
        if (!this.config.isEnabled() || suggestions.isEmpty()) {
            return;
        }
        writer.print("  " + this.colorScheme.suggestionIcon("\ud83d\udca1 "));
        writer.println("Suggested fix" + (suggestions.size() > 1 ? "es:" : ":"));
        int count = 0;
        for (Suggestion suggestion : suggestions) {
            if (++count > this.config.getMaxPerError()) break;
            this.renderSuggestion(suggestion, count, suggestions.size(), writer);
        }
        if (this.config.isShowAutoFixHint() && this.hasAutoFixable(suggestions)) {
            writer.println("  " + this.colorScheme.autoFixHint("\ud83d\udd27 Auto-fixable: Use --fix to apply suggested changes"));
        }
    }

    private void renderSuggestion(Suggestion suggestion, int index, int total, PrintWriter writer) {
        String indent;
        String prefix = total > 1 ? String.format("  %d. ", index) : "  ";
        writer.println(prefix + this.colorScheme.suggestion(suggestion.getDescription()));
        if (suggestion.hasFixedValue()) {
            indent = total > 1 ? "     " : "  ";
            writer.println(indent + this.colorScheme.code(suggestion.getFixedValue()));
        }
        if (suggestion.getExplanation() != null) {
            indent = total > 1 ? "     " : "  ";
            writer.println(indent + suggestion.getExplanation());
        }
        if (this.config.isShowExamples() && suggestion.hasExamples()) {
            this.renderExamples(suggestion.getExamples(), total > 1, writer);
        }
    }

    private void renderExamples(List<String> examples, boolean numbered, PrintWriter writer) {
        String indent = numbered ? "     " : "  ";
        writer.println(indent + "Examples:");
        for (String example : examples) {
            writer.println(indent + "- " + this.colorScheme.code(example));
        }
    }

    private boolean hasAutoFixable(List<Suggestion> suggestions) {
        return suggestions.stream().anyMatch(Suggestion::isAutoFixable);
    }
}

