/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.report.console;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.output.DisplayConfig;
import com.dataliquid.asciidoc.linter.config.output.SummaryConfig;
import com.dataliquid.asciidoc.linter.report.console.ColorScheme;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SummaryRenderer {
    private final SummaryConfig config;
    private final ColorScheme colorScheme;

    public SummaryRenderer(SummaryConfig config, DisplayConfig displayConfig) {
        this.config = Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        this.colorScheme = new ColorScheme(displayConfig.isUseColors());
    }

    public void render(ValidationResult result, PrintWriter writer) {
        if (!this.config.isEnabled()) {
            return;
        }
        writer.println();
        writer.println(this.colorScheme.separator("\u2550".repeat(65)));
        writer.println(this.colorScheme.header("                    Validation Summary"));
        writer.println(this.colorScheme.separator("\u2550".repeat(65)));
        if (this.config.isShowStatistics()) {
            this.renderStatistics(result, writer);
        }
        if (this.config.isShowMostCommon()) {
            this.renderMostCommonIssues(result, writer);
        }
        if (this.config.isShowFileList()) {
            this.renderFileList(result, writer);
        }
        this.renderSummaryLine(result, writer);
        writer.println(this.colorScheme.separator("\u2550".repeat(65)));
    }

    private void renderStatistics(ValidationResult result, PrintWriter writer) {
        int totalFiles = this.getUniqueFileCount(result);
        int filesWithErrors = this.getFilesWithErrorCount(result);
        writer.println("  Total files scanned:     " + totalFiles);
        writer.println("  Files with errors:       " + filesWithErrors);
        writer.println();
        int errors = result.getErrorCount();
        int warnings = result.getWarningCount();
        int infos = result.getInfoCount();
        int total = errors + warnings + infos;
        if (total > 0) {
            writer.println("  Errors:   " + this.colorScheme.error(String.valueOf(errors)));
            writer.println("  Warnings: " + this.colorScheme.warning(String.valueOf(warnings)));
            writer.println("  Info:     " + this.colorScheme.info(String.valueOf(infos)));
            writer.println();
        }
    }

    private void renderMostCommonIssues(ValidationResult result, PrintWriter writer) {
        Map issueFrequency = result.getMessages().stream().collect(Collectors.groupingBy(ValidationMessage::getRuleId, LinkedHashMap::new, Collectors.counting()));
        if (issueFrequency.isEmpty()) {
            return;
        }
        writer.println("  Most common issues:");
        issueFrequency.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).forEach(entry -> {
            String ruleId = (String)entry.getKey();
            long count = (Long)entry.getValue();
            String description = result.getMessages().stream().filter(msg -> msg.getRuleId().equals(ruleId)).findFirst().map(msg -> this.extractShortDescription(msg.getMessage())).orElse(ruleId);
            writer.printf("  - %s (%d occurrence%s)%n", description, count, count == 1L ? "" : "s");
        });
        writer.println();
        long autoFixableCount = result.getMessages().stream().filter(ValidationMessage::hasAutoFixableSuggestions).count();
        if (autoFixableCount > 0L) {
            writer.println(this.colorScheme.suggestionIcon("  \ud83d\udca1 ") + autoFixableCount + " error" + (autoFixableCount == 1L ? " is" : "s are") + " auto-fixable. Run with --fix");
            writer.println();
        }
    }

    private void renderFileList(ValidationResult result, PrintWriter writer) {
        Map<String, List<ValidationMessage>> byFile = result.getMessagesByFile();
        if (byFile.isEmpty()) {
            return;
        }
        writer.println("  Files with issues:");
        byFile.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            String filename = (String)entry.getKey();
            List messages = (List)entry.getValue();
            long errorCount = messages.stream().filter(msg -> msg.getSeverity() == Severity.ERROR).count();
            long warnCount = messages.stream().filter(msg -> msg.getSeverity() == Severity.WARN).count();
            writer.printf("  - %s: ", filename);
            if (errorCount > 0L) {
                writer.print(this.colorScheme.error(errorCount + " error" + (errorCount == 1L ? "" : "s")));
                if (warnCount > 0L) {
                    writer.print(", ");
                }
            }
            if (warnCount > 0L) {
                writer.print(this.colorScheme.warning(warnCount + " warning" + (warnCount == 1L ? "" : "s")));
            }
            writer.println();
        });
        writer.println();
    }

    private void renderSummaryLine(ValidationResult result, PrintWriter writer) {
        int errors = result.getErrorCount();
        int warnings = result.getWarningCount();
        int infos = result.getInfoCount();
        String summary = String.format("Summary: %d error%s, %d warning%s, %d info message%s", errors, errors == 1 ? "" : "s", warnings, warnings == 1 ? "" : "s", infos, infos == 1 ? "" : "s");
        summary = errors > 0 ? this.colorScheme.error(summary) : (warnings > 0 ? this.colorScheme.warning(summary) : this.colorScheme.success(summary));
        writer.println();
        writer.println(summary);
        writer.println("Validation completed in " + result.getValidationTimeMillis() + "ms");
    }

    private int getUniqueFileCount(ValidationResult result) {
        return result.getScannedFileCount();
    }

    private int getFilesWithErrorCount(ValidationResult result) {
        return (int)result.getMessages().stream().filter(msg -> msg.getSeverity() == Severity.ERROR).map(msg -> msg.getLocation().getFilename()).distinct().count();
    }

    private String extractShortDescription(String message) {
        if (message == null) {
            return "";
        }
        int newlineIndex = message.indexOf(10);
        if (newlineIndex > 0) {
            return message.substring(0, newlineIndex).trim();
        }
        return message.trim();
    }
}

