/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.SectionConfig;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import com.dataliquid.asciidoc.linter.validator.block.BlockContainer;
import com.dataliquid.asciidoc.linter.validator.block.BlockOccurrenceValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockTypeDetector;
import com.dataliquid.asciidoc.linter.validator.block.BlockTypeValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidatorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;

public final class BlockValidator {
    private final BlockValidatorFactory validatorFactory = new BlockValidatorFactory();
    private final BlockTypeDetector typeDetector = new BlockTypeDetector();
    private final BlockOccurrenceValidator occurrenceValidator = new BlockOccurrenceValidator();

    public ValidationResult validate(Document document, SectionConfig config, String filename) {
        Objects.requireNonNull(document, "[" + this.getClass().getName() + "] document must not be null");
        Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        Objects.requireNonNull(filename, "[" + this.getClass().getName() + "] filename must not be null");
        BlockContainer container = BlockContainer.fromDocument(document);
        BlockValidationContext context = new BlockValidationContext(document, filename);
        return this.validateContainer(container, config, context, filename);
    }

    public ValidationResult validate(Section section, SectionConfig config, String filename) {
        Objects.requireNonNull(section, "[" + this.getClass().getName() + "] section must not be null");
        Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        Objects.requireNonNull(filename, "[" + this.getClass().getName() + "] filename must not be null");
        BlockContainer container = BlockContainer.fromSection(section);
        BlockValidationContext context = new BlockValidationContext(section, filename);
        return this.validateContainer(container, config, context, filename);
    }

    private ValidationResult validateContainer(BlockContainer container, SectionConfig config, BlockValidationContext context, String filename) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (config.allowedBlocks() == null || config.allowedBlocks().isEmpty()) {
            return ValidationResult.builder().addMessages(messages).build();
        }
        this.validateContainerBlocks(container, config, context, messages);
        messages.addAll(this.occurrenceValidator.validate(context, config.allowedBlocks()));
        this.validateBlockOrder(container, config, context, messages);
        return ValidationResult.builder().addMessages(messages).build();
    }

    private void validateContainerBlocks(BlockContainer container, SectionConfig config, BlockValidationContext context, List<ValidationMessage> messages) {
        List<StructuralNode> blocks = container.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        for (StructuralNode block : blocks) {
            try {
                if (block instanceof Section) continue;
                BlockType actualType = this.typeDetector.detectType(block);
                if (actualType == null) {
                    messages.add(ValidationMessage.builder().severity(Severity.ERROR).ruleId("block.type.unknown").location(context.createLocation(block)).message("Unknown block type: " + block.getContext()).actualValue(block.getContext()).expectedValue("Valid AsciiDoc block type").build());
                    continue;
                }
                Block blockConfig = this.findBlockConfig(actualType, block, config.allowedBlocks());
                if (blockConfig == null) {
                    messages.add(ValidationMessage.builder().severity(Severity.ERROR).ruleId("block.type.not-allowed").location(context.createLocation(block)).message("Block type not allowed in " + container.getContainerType()).actualValue(actualType.toString()).expectedValue("One of the allowed block types").build());
                    continue;
                }
                context.trackBlock(blockConfig, block);
                BlockTypeValidator validator = this.validatorFactory.getValidator(actualType);
                if (validator == null) continue;
                messages.addAll(validator.validate(block, blockConfig, context));
            }
            catch (Exception e) {
                messages.add(ValidationMessage.builder().severity(Severity.ERROR).ruleId("block.validation.error").location(context.createLocation(block)).message("Error validating block: " + e.getMessage()).build());
            }
        }
    }

    private Block findBlockConfig(BlockType type, StructuralNode block, List<Block> configs) {
        Object nameAttr = block.getAttribute((Object)"name");
        if (nameAttr != null) {
            String blockName = nameAttr.toString();
            for (Block config : configs) {
                if (config.getType() != type || !blockName.equals(config.getName())) continue;
                return config;
            }
        }
        for (Block config : configs) {
            if (config.getType() != type) continue;
            return config;
        }
        return null;
    }

    private Block findBlockConfigForOrder(BlockType type, StructuralNode block, List<Block> configs, Set<Block> alreadyMatched) {
        Object nameAttr = block.getAttribute((Object)"name");
        if (nameAttr != null) {
            String blockName = nameAttr.toString();
            for (Block config : configs) {
                if (config.getType() != type || !blockName.equals(config.getName()) || alreadyMatched.contains(config)) continue;
                return config;
            }
        }
        for (Block config : configs) {
            if (config.getType() != type || alreadyMatched.contains(config)) continue;
            return config;
        }
        return null;
    }

    private void validateBlockOrder(BlockContainer container, SectionConfig config, BlockValidationContext context, List<ValidationMessage> messages) {
        List orderedBlocks = config.allowedBlocks().stream().filter(block -> block.getOrder() != null).sorted((b1, b2) -> b1.getOrder().compareTo(b2.getOrder())).collect(Collectors.toList());
        if (orderedBlocks.isEmpty()) {
            return;
        }
        List<StructuralNode> blocks = container.getBlocks();
        ArrayList<Block> matchedBlockConfigs = new ArrayList<Block>();
        HashSet<Block> alreadyMatched = new HashSet<Block>();
        for (StructuralNode block2 : blocks) {
            Block blockConfig;
            BlockType type;
            if (block2 instanceof Section || (type = this.typeDetector.detectType(block2)) == null || (blockConfig = this.findBlockConfigForOrder(type, block2, config.allowedBlocks(), alreadyMatched)) == null || blockConfig.getOrder() == null) continue;
            matchedBlockConfigs.add(blockConfig);
            alreadyMatched.add(blockConfig);
        }
        for (int i = 0; i < matchedBlockConfigs.size() - 1; ++i) {
            Block current = (Block)matchedBlockConfigs.get(i);
            Block next = (Block)matchedBlockConfigs.get(i + 1);
            if (current.getOrder() <= next.getOrder()) continue;
            int currentBlockIndex = -1;
            int nextBlockIndex = -1;
            int blockIndex = 0;
            for (int j = 0; j < blocks.size(); ++j) {
                StructuralNode block3 = blocks.get(j);
                if (block3 instanceof Section) continue;
                BlockType type = this.typeDetector.detectType(block3);
                if (type != null) {
                    Block blockCfg = this.findBlockConfig(type, block3, config.allowedBlocks());
                    if (blockCfg == current && currentBlockIndex == -1) {
                        currentBlockIndex = j;
                    } else if (blockCfg == next && nextBlockIndex == -1) {
                        nextBlockIndex = j;
                    }
                }
                ++blockIndex;
            }
            String currentKey = current.getName() != null ? current.getName() : current.getType().toString();
            String nextKey = next.getName() != null ? next.getName() : next.getType().toString();
            messages.add(ValidationMessage.builder().severity(Severity.ERROR).ruleId("block.order").location(context.createLocation(blocks.get(currentBlockIndex))).message("Block order violation: '" + currentKey + "' (order=" + current.getOrder() + ") appears after '" + nextKey + "' (order=" + next.getOrder() + ")").actualValue(currentKey + " at position " + i).expectedValue(currentKey + " should appear before " + nextKey).build());
        }
    }
}

